/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.server.startup.RouteTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ConfigureRoutes
extends ConfiguredRoutes
implements Serializable {
    private final Map<String, RouteTarget> routeMap;
    private final Map<Class<? extends Component>, String> targetRouteMap;
    private final Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetMap;

    public ConfigureRoutes() {
        this.routeMap = new HashMap<String, RouteTarget>();
        this.targetRouteMap = new HashMap<Class<? extends Component>, String>();
        this.exceptionTargetMap = new HashMap<Class<? extends Exception>, Class<? extends Component>>();
    }

    public ConfigureRoutes(ConfiguredRoutes original) {
        HashMap<String, RouteTarget> routesMap = new HashMap<String, RouteTarget>();
        HashMap<Class<? extends Component>, String> targetRoutesMap = new HashMap<Class<? extends Component>, String>();
        HashMap<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap = new HashMap<Class<? extends Exception>, Class<? extends Component>>();
        for (Map.Entry<String, RouteTarget> route : original.getRoutesMap().entrySet()) {
            routesMap.put(route.getKey(), route.getValue().copy(true));
        }
        targetRoutesMap.putAll(original.getTargetRoutes());
        exceptionTargetsMap.putAll(original.getExceptionHandlers());
        this.routeMap = routesMap;
        this.targetRouteMap = targetRoutesMap;
        this.exceptionTargetMap = exceptionTargetsMap;
    }

    @Override
    protected Map<String, RouteTarget> getRoutesMap() {
        return this.routeMap;
    }

    @Override
    public Map<Class<? extends Component>, String> getTargetRoutes() {
        return this.targetRouteMap;
    }

    @Override
    public Map<Class<? extends Exception>, Class<? extends Component>> getExceptionHandlers() {
        return this.exceptionTargetMap;
    }

    public void clear() {
        this.getRoutesMap().clear();
        this.getTargetRoutes().clear();
    }

    public void setRoute(String path, Class<? extends Component> navigationTarget) {
        if (this.hasRoute(path)) {
            this.getRoutesMap().get(path).addRoute(navigationTarget);
        } else {
            this.getRoutesMap().computeIfAbsent(path, key -> new RouteTarget(navigationTarget, true));
        }
    }

    public void setTargetRoute(Class<? extends Component> navigationTarget, String path) {
        this.getTargetRoutes().put(navigationTarget, path);
    }

    public void setErrorRoute(Class<? extends Exception> exception, Class<? extends Component> errorTarget) {
        this.getExceptionHandlers().put(exception, errorTarget);
    }

    public void removeRoute(Class<? extends Component> targetRoute) {
        if (!this.hasRouteTarget(targetRoute)) {
            return;
        }
        this.getTargetRoutes().remove(targetRoute);
        ArrayList emptyRoutes = new ArrayList();
        this.getRoutesMap().forEach((route, routeTarget) -> {
            routeTarget.remove(targetRoute);
            if (routeTarget.isEmpty()) {
                emptyRoutes.add(route);
            }
        });
        emptyRoutes.forEach(this.getRoutesMap()::remove);
    }

    public void removeRoute(String path) {
        if (!this.hasRoute(path)) {
            return;
        }
        RouteTarget removedRoute = this.getRoutesMap().remove(path);
        for (Class<? extends Component> targetRoute : removedRoute.getRoutes()) {
            this.updateMainRouteTarget(targetRoute);
        }
    }

    public void removeRoute(String path, Class<? extends Component> targetRoute) {
        if (!this.hasRoute(path) || !this.getRoutesMap().get(path).containsTarget(targetRoute)) {
            return;
        }
        RouteTarget routeTarget = this.getRoutesMap().get(path);
        routeTarget.remove(targetRoute);
        if (routeTarget.isEmpty()) {
            this.getRoutesMap().remove(path);
        }
        if (this.getTargetRoutes().containsKey(targetRoute) && this.getTargetRoutes().get(targetRoute).equals(path)) {
            this.updateMainRouteTarget(targetRoute);
        }
    }

    private void updateMainRouteTarget(Class<? extends Component> navigationTarget) {
        this.getTargetRoutes().remove(navigationTarget);
        for (Map.Entry<String, RouteTarget> entry : this.getRoutesMap().entrySet()) {
            if (!entry.getValue().containsTarget(navigationTarget)) continue;
            this.getTargetRoutes().put(navigationTarget, entry.getKey());
            return;
        }
    }
}

