/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.connect.generator;

import java.util.Arrays;

final class GeneratorUtils {
    private GeneratorUtils() {
    }

    static boolean equals(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    static int compare(String s1, String s2) {
        return GeneratorUtils.equals(s1, s2) ? 0 : (s1 == null ? -1 : (s2 == null ? 1 : s1.compareTo(s2)));
    }

    static String capitalize(String s) {
        return s == null ? s : s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    static boolean isBlank(String s) {
        return s == null || s.replaceAll("\\s+", "").isEmpty();
    }

    static boolean isNotBlank(String s) {
        return !GeneratorUtils.isBlank(s);
    }

    static String firstNonBlank(String ... values) {
        return Arrays.stream(values).filter(GeneratorUtils::isNotBlank).findFirst().orElse(null);
    }

    static boolean isTrue(Boolean b) {
        return Boolean.TRUE.equals(b);
    }

    static boolean isNotTrue(Boolean b) {
        return !GeneratorUtils.isTrue(b);
    }

    static <T> T defaultIfNull(T o, T def) {
        return o != null ? o : def;
    }

    static String replaceChars(String s, char c1, char c2) {
        return s == null ? s : s.replace(c1, c2);
    }

    static boolean contains(String s, String p) {
        return GeneratorUtils.isNotBlank(s) && GeneratorUtils.isNotBlank(p) && s.contains(p);
    }

    static String substringAfter(String s, String p) {
        return GeneratorUtils.contains(s, p) ? s.substring(s.indexOf(p) + p.length()) : "";
    }

    static String substringAfterLast(String s, String p) {
        return GeneratorUtils.contains(s, p) ? s.substring(s.lastIndexOf(p) + p.length()) : "";
    }

    static String substringBeforeLast(String s, String p) {
        return GeneratorUtils.contains(s, p) ? s.substring(0, s.lastIndexOf(p)) : s;
    }

    static boolean endsWith(String s, String p) {
        return GeneratorUtils.contains(s, p) && s.length() == p.length() + s.lastIndexOf(p);
    }

    static String removeEnd(String s, String p) {
        return GeneratorUtils.endsWith(s, p) ? s.substring(0, s.lastIndexOf(p)) : s;
    }
}

