/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.JavaScriptNavigationStateRenderer;
import com.vaadin.flow.component.internal.UIInternalUpdater;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.internal.ErrorStateRenderer;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JavaScriptBootstrapUI
extends UI {
    public static final String SERVER_ROUTING = "clientRoutingMode";
    static final String SERVER_CONNECTED = "this.serverConnected($0)";
    static final String CLIENT_NAVIGATE_TO = "window.dispatchEvent(new CustomEvent('vaadin-router-go', {detail: new URL($0, document.baseURI)}))";
    Element wrapperElement;
    private NavigationState clientViewNavigationState;
    private boolean navigationInProgress = false;
    private String forwardToClientUrl = null;

    public JavaScriptBootstrapUI() {
        super(new JavaScriptUIInternalUpdater());
    }

    @Override
    public Stream<Component> getChildren() {
        if (this.wrapperElement == null) {
            return super.getChildren();
        }
        Stream.Builder childComponents = Stream.builder();
        this.wrapperElement.getChildren().forEach(childElement -> ComponentUtil.findComponents(childElement, childComponents::add));
        super.getChildren().forEach(childComponents::add);
        return childComponents.build();
    }

    public String getForwardToClientUrl() {
        return this.forwardToClientUrl;
    }

    @ClientCallable
    public void connectClient(String clientElementTag, String clientElementId, String flowRoute, String appShellTitle, JsonValue historyState) {
        String trimmedRoute;
        if (appShellTitle != null && !appShellTitle.isEmpty()) {
            this.getInternals().setAppShellTitle(appShellTitle);
        }
        if (!(trimmedRoute = PathUtil.trimPath(flowRoute)).equals(flowRoute)) {
            this.getPage().getHistory().replaceState(null, trimmedRoute);
        }
        Location location = new Location(trimmedRoute);
        if (this.wrapperElement == null) {
            this.wrapperElement = new Element(clientElementTag);
            this.getElement().getStateProvider().appendVirtualChild(this.getElement().getNode(), this.wrapperElement, "@id", clientElementId);
            this.getPage().getHistory().setHistoryStateChangeHandler(event -> this.renderViewForRoute(event.getLocation(), NavigationTrigger.CLIENT_SIDE));
            this.renderViewForRoute(location, NavigationTrigger.CLIENT_SIDE);
        } else {
            History.HistoryStateChangeHandler handler = this.getPage().getHistory().getHistoryStateChangeHandler();
            handler.onHistoryStateChange(new History.HistoryStateChangeEvent(this.getPage().getHistory(), historyState, location, NavigationTrigger.CLIENT_SIDE));
        }
        if (this.getForwardToClientUrl() != null) {
            this.navigateToClient(this.getForwardToClientUrl());
            this.acknowledgeClient();
        } else if (this.isPostponed()) {
            this.cancelClient();
        } else {
            this.acknowledgeClient();
        }
        this.getSession().setAttribute(SERVER_ROUTING, Boolean.FALSE);
    }

    @ClientCallable
    public void leaveNavigation(String route) {
        this.navigateToPlaceholder(new Location(PathUtil.trimPath(route)));
        if (this.isPostponed()) {
            this.cancelClient();
        } else {
            this.acknowledgeClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void navigate(String pathname, QueryParameters queryParameters) {
        Location location = new Location(pathname, queryParameters);
        if (Boolean.TRUE.equals(this.getSession().getAttribute(SERVER_ROUTING))) {
            this.renderViewForRoute(location, NavigationTrigger.UI_NAVIGATE);
            return;
        }
        if (this.navigationInProgress || this.getInternals().hasLastHandledLocation() && this.sameLocation(this.getInternals().getLastHandledLocation(), location)) {
            return;
        }
        this.navigationInProgress = true;
        try {
            Optional<NavigationState> navigationState = this.getInternals().getRouter().resolveNavigationTarget(location);
            if (navigationState.isPresent()) {
                this.handleNavigation(location, navigationState.get(), NavigationTrigger.UI_NAVIGATE);
                if (this.getForwardToClientUrl() != null) {
                    this.navigateToClient(this.getForwardToClientUrl());
                }
            } else {
                this.navigateToClient(location.getPathWithQueryParameters());
            }
        }
        finally {
            this.navigationInProgress = false;
        }
    }

    void navigateToClient(String clientRoute) {
        this.getPage().executeJs(CLIENT_NAVIGATE_TO, new Serializable[]{clientRoute});
    }

    private void acknowledgeClient() {
        this.serverConnected(false);
    }

    private void cancelClient() {
        this.serverConnected(true);
    }

    private void serverConnected(boolean cancel) {
        this.wrapperElement.executeJs(SERVER_CONNECTED, Boolean.valueOf(cancel));
    }

    private void navigateToPlaceholder(Location location) {
        if (this.clientViewNavigationState == null) {
            this.clientViewNavigationState = new NavigationStateBuilder(this.getInternals().getRouter()).withTarget(ClientViewPlaceholder.class).build();
        }
        this.handleNavigation(location, this.clientViewNavigationState, NavigationTrigger.CLIENT_SIDE);
    }

    private void renderViewForRoute(Location location, NavigationTrigger trigger) {
        if (!this.shouldHandleNavigation(location)) {
            return;
        }
        this.getInternals().setLastHandledNavigation(location);
        Optional<NavigationState> navigationState = this.getInternals().getRouter().resolveNavigationTarget(location);
        if (navigationState.isPresent()) {
            this.handleNavigation(location, navigationState.get(), trigger);
        } else {
            this.navigateToPlaceholder(location);
            if (!this.isPostponed()) {
                this.handleErrorNavigation(location);
            }
        }
    }

    private boolean shouldHandleNavigation(Location location) {
        return !this.getInternals().hasLastHandledLocation() || !this.sameLocation(this.getInternals().getLastHandledLocation(), location);
    }

    private boolean sameLocation(Location oldLocation, Location newLocation) {
        return PathUtil.trimPath(newLocation.getPathWithQueryParameters()).equals(PathUtil.trimPath(oldLocation.getPathWithQueryParameters()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNavigation(Location location, NavigationState navigationState, NavigationTrigger trigger) {
        try {
            NavigationEvent navigationEvent = new NavigationEvent(this.getInternals().getRouter(), location, this, trigger);
            JavaScriptNavigationStateRenderer clientNavigationStateRenderer = new JavaScriptNavigationStateRenderer(navigationState);
            clientNavigationStateRenderer.handle(navigationEvent);
            this.forwardToClientUrl = clientNavigationStateRenderer.getClientForwardRoute();
            this.adjustPageTitle();
        }
        catch (Exception exception) {
            this.handleExceptionNavigation(location, exception);
        }
        finally {
            this.getInternals().clearLastHandledNavigation();
        }
    }

    private boolean handleExceptionNavigation(Location location, Exception exception) {
        Optional<ErrorTargetEntry> maybeLookupResult = this.getInternals().getRouter().getErrorNavigationTarget(exception);
        if (!maybeLookupResult.isPresent()) {
            throw new RuntimeException(exception);
        }
        ErrorTargetEntry lookupResult = maybeLookupResult.get();
        ErrorParameter<? extends Exception> errorParameter = new ErrorParameter<Exception>(lookupResult.getHandledExceptionType(), exception, exception.getMessage());
        ErrorStateRenderer errorStateRenderer = new ErrorStateRenderer(new NavigationStateBuilder(this.getInternals().getRouter()).withTarget(lookupResult.getNavigationTarget()).build());
        ErrorNavigationEvent errorNavigationEvent = new ErrorNavigationEvent(this.getInternals().getRouter(), location, this, NavigationTrigger.CLIENT_SIDE, errorParameter);
        errorStateRenderer.handle(errorNavigationEvent);
        return this.isPostponed();
    }

    private boolean isPostponed() {
        return this.getInternals().getContinueNavigationAction() != null;
    }

    private void adjustPageTitle() {
        String newTitle = this.getInternals().getTitle();
        String appShellTitle = this.getInternals().getAppShellTitle();
        if ((newTitle == null || newTitle.isEmpty()) && appShellTitle != null && !appShellTitle.isEmpty()) {
            this.getInternals().cancelPendingTitleUpdate();
            this.getInternals().setTitle(appShellTitle);
        }
    }

    private void handleErrorNavigation(Location location) {
        NavigationState errorNavigationState = this.getInternals().getRouter().resolveRouteNotFoundNavigationTarget().orElse(this.getDefaultNavigationError());
        ErrorStateRenderer errorStateRenderer = new ErrorStateRenderer(errorNavigationState);
        NotFoundException notFoundException = new NotFoundException("Couldn't find route for '" + location.getPath() + "'");
        ErrorParameter<NotFoundException> errorParameter = new ErrorParameter<NotFoundException>(NotFoundException.class, notFoundException);
        ErrorNavigationEvent errorNavigationEvent = new ErrorNavigationEvent(this.getInternals().getRouter(), location, this, NavigationTrigger.CLIENT_SIDE, errorParameter);
        errorStateRenderer.handle(errorNavigationEvent);
    }

    private NavigationState getDefaultNavigationError() {
        return new NavigationStateBuilder(this.getInternals().getRouter()).withTarget(RouteNotFoundError.class).build();
    }

    @Tag(value="div")
    @AnonymousAllowed
    public static class ClientViewPlaceholder
    extends Component {
    }

    private static class JavaScriptUIInternalUpdater
    implements UIInternalUpdater {
        private JavaScriptUIInternalUpdater() {
        }

        @Override
        public void updateRoot(UI ui, HasElement oldRoot, HasElement newRoot) {
            JavaScriptBootstrapUI jsUI = this.castToJavaScriptUI(ui);
            Element wrapperElement = jsUI.wrapperElement;
            if (wrapperElement == null) {
                UIInternalUpdater.super.updateRoot(ui, oldRoot, newRoot);
                return;
            }
            Element rootElement = newRoot.getElement();
            if (newRoot instanceof ClientViewPlaceholder) {
                wrapperElement.removeAllChildren();
            } else if (!wrapperElement.equals(rootElement.getParent())) {
                if (oldRoot != null) {
                    oldRoot.getElement().removeFromParent();
                }
                rootElement.removeFromParent();
                wrapperElement.appendChild(rootElement);
            }
        }

        @Override
        public void moveToNewUI(UI oldUI, UI newUI) {
            JavaScriptBootstrapUI newJsUI = this.castToJavaScriptUI(newUI);
            JavaScriptBootstrapUI oldJsUI = this.castToJavaScriptUI(oldUI);
            Element oldRoot = oldJsUI.getElement();
            Element newRoot = newJsUI.getElement();
            oldRoot.getChildren().collect(Collectors.toList()).forEach(element -> {
                element.removeFromTree();
                newRoot.appendChild((Element)element);
            });
        }

        private JavaScriptBootstrapUI castToJavaScriptUI(UI ui) {
            assert (ui instanceof JavaScriptBootstrapUI);
            return (JavaScriptBootstrapUI)ui;
        }
    }
}

