/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.Date;

public class ExtendedClientDetails
implements Serializable {
    private int screenWidth = -1;
    private int screenHeight = -1;
    private int windowInnerWidth = -1;
    private int windowInnerHeight = -1;
    private int bodyClientWidth = -1;
    private int bodyClientHeight = -1;
    private int timezoneOffset = 0;
    private int rawTimezoneOffset = 0;
    private int dstSavings;
    private boolean dstInEffect;
    private String timeZoneId;
    private long clientServerTimeDelta;
    private boolean touchDevice;
    private double devicePixelRatio = -1.0;
    private String windowName;
    private String navigatorPlatform;

    ExtendedClientDetails(String screenWidth, String screenHeight, String windowInnerWidth, String windowInnerHeight, String bodyClientWidth, String bodyClientHeight, String tzOffset, String rawTzOffset, String dstShift, String dstInEffect, String tzId, String curDate, String touchDevice, String devicePixelRatio, String windowName, String navigatorPlatform) {
        if (screenWidth != null) {
            try {
                this.screenWidth = Integer.parseInt(screenWidth);
                this.screenHeight = Integer.parseInt(screenHeight);
            }
            catch (NumberFormatException e) {
                this.screenWidth = -1;
                this.screenHeight = -1;
            }
        }
        if (bodyClientHeight != null) {
            try {
                this.bodyClientHeight = Integer.parseInt(bodyClientHeight);
                this.bodyClientWidth = Integer.parseInt(bodyClientWidth);
            }
            catch (NumberFormatException e) {
                this.bodyClientWidth = -1;
                this.bodyClientHeight = -1;
            }
        }
        if (windowInnerHeight != null) {
            try {
                this.windowInnerHeight = Integer.parseInt(windowInnerHeight);
                this.windowInnerWidth = Integer.parseInt(windowInnerWidth);
            }
            catch (NumberFormatException e) {
                this.windowInnerWidth = -1;
                this.windowInnerHeight = -1;
            }
        }
        if (tzOffset != null) {
            try {
                this.timezoneOffset = -Integer.parseInt(tzOffset) * 60 * 1000;
            }
            catch (NumberFormatException e) {
                this.timezoneOffset = 0;
            }
        }
        if (rawTzOffset != null) {
            try {
                this.rawTimezoneOffset = -Integer.parseInt(rawTzOffset) * 60 * 1000;
            }
            catch (NumberFormatException e) {
                this.rawTimezoneOffset = 0;
            }
        }
        if (dstShift != null) {
            try {
                this.dstSavings = Integer.parseInt(dstShift) * 60 * 1000;
            }
            catch (NumberFormatException e) {
                this.dstSavings = 0;
            }
        }
        if (dstInEffect != null) {
            this.dstInEffect = Boolean.parseBoolean(dstInEffect);
        }
        this.timeZoneId = tzId == null || "undefined".equals(tzId) ? null : tzId;
        if (curDate != null) {
            try {
                long curTime = Long.parseLong(curDate);
                this.clientServerTimeDelta = curTime - new Date().getTime();
            }
            catch (NumberFormatException e) {
                this.clientServerTimeDelta = 0L;
            }
        }
        if (touchDevice != null) {
            this.touchDevice = Boolean.parseBoolean(touchDevice);
        }
        if (devicePixelRatio != null) {
            this.devicePixelRatio = Double.parseDouble(devicePixelRatio);
        }
        this.windowName = windowName;
        this.navigatorPlatform = navigatorPlatform;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getWindowInnerHeight() {
        return this.windowInnerHeight;
    }

    public int getWindowInnerWidth() {
        return this.windowInnerWidth;
    }

    public int getBodyClientHeight() {
        return this.bodyClientHeight;
    }

    public int getBodyClientWidth() {
        return this.bodyClientWidth;
    }

    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public int getRawTimezoneOffset() {
        return this.rawTimezoneOffset;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public boolean isDSTInEffect() {
        return this.dstInEffect;
    }

    public Date getCurrentDate() {
        return new Date(new Date().getTime() + this.clientServerTimeDelta);
    }

    public boolean isTouchDevice() {
        return this.touchDevice;
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public boolean isIPad() {
        return this.navigatorPlatform != null && this.navigatorPlatform.startsWith("iPad");
    }

    public boolean isIOS() {
        return this.isIPad() || VaadinSession.getCurrent().getBrowser().isIPhone() || this.navigatorPlatform != null && this.navigatorPlatform.startsWith("iPod");
    }
}

