/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import com.vaadin.flow.internal.nodefeature.BasicTypeValue;
import com.vaadin.flow.internal.nodefeature.ClientCallableHandlers;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ElementStylePropertyMap;
import com.vaadin.flow.internal.nodefeature.LoadingIndicatorConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ModelList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.PollConfigurationMap;
import com.vaadin.flow.internal.nodefeature.PolymerEventListenerMap;
import com.vaadin.flow.internal.nodefeature.PolymerServerEventHandlers;
import com.vaadin.flow.internal.nodefeature.PushConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReconnectDialogConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ShadowRootData;
import com.vaadin.flow.internal.nodefeature.ShadowRootHost;
import com.vaadin.flow.internal.nodefeature.TextNodeMap;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class NodeFeatureRegistry {
    private static int nextNodePriority = 0;
    static final Map<Class<? extends NodeFeature>, NodeFeatureData> nodeFeatures = new HashMap<Class<? extends NodeFeature>, NodeFeatureData>();
    private static final Map<Integer, Class<? extends NodeFeature>> idToFeature = new HashMap<Integer, Class<? extends NodeFeature>>();
    public static final Comparator<Class<? extends NodeFeature>> PRIORITY_COMPARATOR = Comparator.comparingInt(feature -> NodeFeatureData.access$400(NodeFeatureRegistry.getData(feature)));

    private NodeFeatureRegistry() {
    }

    private static <T extends NodeFeature> void registerFeature(Class<T> type, SerializableFunction<StateNode, T> factory, int id) {
        NodeFeatureData featureData = new NodeFeatureData(factory, id);
        nodeFeatures.put(type, featureData);
        idToFeature.put(featureData.id, type);
    }

    public static NodeFeature create(Class<? extends NodeFeature> nodeFeatureType, StateNode node) {
        assert (node != null);
        return (NodeFeature)NodeFeatureRegistry.getData(nodeFeatureType).factory.apply(node);
    }

    public static int getId(Class<? extends NodeFeature> nodeFeature) {
        return NodeFeatureRegistry.getData(nodeFeature).id;
    }

    public static Collection<Class<? extends NodeFeature>> getFeatures() {
        return Collections.unmodifiableCollection(nodeFeatures.keySet());
    }

    private static NodeFeatureData getData(Class<? extends NodeFeature> nodeFeature) {
        assert (nodeFeature != null);
        NodeFeatureData data = nodeFeatures.get(nodeFeature);
        assert (data != null) : "Feature " + nodeFeature.getName() + " has not been registered in NodeFeatureRegistry";
        return data;
    }

    public static Class<? extends NodeFeature> getFeature(int featureId) {
        return idToFeature.get(featureId);
    }

    static {
        NodeFeatureRegistry.registerFeature(ElementData.class, ElementData::new, 0);
        NodeFeatureRegistry.registerFeature(TextNodeMap.class, TextNodeMap::new, 7);
        NodeFeatureRegistry.registerFeature(ModelList.class, ModelList::new, 16);
        NodeFeatureRegistry.registerFeature(BasicTypeValue.class, BasicTypeValue::new, 23);
        NodeFeatureRegistry.registerFeature(ElementChildrenList.class, ElementChildrenList::new, 2);
        NodeFeatureRegistry.registerFeature(ElementPropertyMap.class, ElementPropertyMap::new, 1);
        NodeFeatureRegistry.registerFeature(ComponentMapping.class, ComponentMapping::new, 15);
        NodeFeatureRegistry.registerFeature(ClientCallableHandlers.class, ClientCallableHandlers::new, 19);
        NodeFeatureRegistry.registerFeature(ElementClassList.class, ElementClassList::new, 11);
        NodeFeatureRegistry.registerFeature(ElementAttributeMap.class, ElementAttributeMap::new, 3);
        NodeFeatureRegistry.registerFeature(ElementListenerMap.class, ElementListenerMap::new, 4);
        NodeFeatureRegistry.registerFeature(VirtualChildrenList.class, VirtualChildrenList::new, 24);
        NodeFeatureRegistry.registerFeature(ReturnChannelMap.class, ReturnChannelMap::new, 25);
        NodeFeatureRegistry.registerFeature(PolymerEventListenerMap.class, PolymerEventListenerMap::new, 18);
        NodeFeatureRegistry.registerFeature(PolymerServerEventHandlers.class, PolymerServerEventHandlers::new, 17);
        NodeFeatureRegistry.registerFeature(ElementStylePropertyMap.class, ElementStylePropertyMap::new, 12);
        NodeFeatureRegistry.registerFeature(ShadowRootData.class, ShadowRootData::new, 20);
        NodeFeatureRegistry.registerFeature(ShadowRootHost.class, ShadowRootHost::new, 21);
        NodeFeatureRegistry.registerFeature(AttachExistingElementFeature.class, AttachExistingElementFeature::new, 22);
        NodeFeatureRegistry.registerFeature(PushConfigurationMap.class, PushConfigurationMap::new, 5);
        NodeFeatureRegistry.registerFeature(PushConfigurationMap.PushConfigurationParametersMap.class, PushConfigurationMap.PushConfigurationParametersMap::new, 6);
        NodeFeatureRegistry.registerFeature(LoadingIndicatorConfigurationMap.class, LoadingIndicatorConfigurationMap::new, 10);
        NodeFeatureRegistry.registerFeature(PollConfigurationMap.class, PollConfigurationMap::new, 8);
        NodeFeatureRegistry.registerFeature(ReconnectDialogConfigurationMap.class, ReconnectDialogConfigurationMap::new, 9);
    }

    private static class NodeFeatureData
    implements Serializable {
        private final SerializableFunction<StateNode, ? extends NodeFeature> factory;
        private final int id;
        private final int priority;

        private <T extends NodeFeature> NodeFeatureData(SerializableFunction<StateNode, T> factory, int id) {
            this.factory = factory;
            this.id = id;
            this.priority = nextNodePriority++;
        }
    }
}

