/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewAccessChecker
implements BeforeEnterListener {
    public static final String SESSION_STORED_REDIRECT = ViewAccessChecker.class.getName() + ".redirect";
    private final AccessAnnotationChecker accessAnnotationChecker;
    private Class<? extends Component> loginView;
    private String loginUrl;
    private boolean enabled = false;

    public ViewAccessChecker() {
        this(new AccessAnnotationChecker());
    }

    protected ViewAccessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        this.accessAnnotationChecker = accessAnnotationChecker;
    }

    public void enable() {
        this.enabled = true;
    }

    public void setLoginView(Class<? extends Component> loginView) {
        this.throwIfLoginViewSet();
        this.loginView = loginView;
    }

    public void setLoginView(String loginUrl) {
        this.throwIfLoginViewSet();
        this.loginUrl = loginUrl;
    }

    private void throwIfLoginViewSet() {
        if (this.loginUrl != null) {
            throw new IllegalStateException("Already using " + this.loginUrl + " as the login view");
        }
        if (this.loginView != null) {
            throw new IllegalStateException("Already using " + this.loginView.getName() + " as the login view");
        }
    }

    @Override
    public void beforeEnter(BeforeEnterEvent beforeEnterEvent) {
        if (!this.enabled) {
            return;
        }
        Class<?> targetView = beforeEnterEvent.getNavigationTarget();
        VaadinServletRequest vaadinServletRequest = VaadinServletRequest.getCurrent();
        if (vaadinServletRequest == null) {
            this.getLogger().warn("Preventing navigation to " + targetView.getName() + " because no HTTP request is available for checking access.");
            beforeEnterEvent.rerouteToError(NotFoundException.class);
            return;
        }
        HttpServletRequest httpServletRequest = vaadinServletRequest.getHttpServletRequest();
        this.getLogger().debug("Checking access for view {}", (Object)targetView.getName());
        if (this.loginView != null && targetView == this.loginView) {
            this.getLogger().debug("Allowing access for login view {}", (Object)targetView.getName());
            return;
        }
        boolean hasAccess = this.accessAnnotationChecker.hasAccess(targetView, httpServletRequest);
        if (hasAccess) {
            this.getLogger().debug("Allowed access to view {}", (Object)targetView.getName());
            return;
        }
        this.getLogger().debug("Denied access to view {}", (Object)targetView.getName());
        if (httpServletRequest.getUserPrincipal() == null) {
            httpServletRequest.getSession().setAttribute(SESSION_STORED_REDIRECT, (Object)beforeEnterEvent.getLocation().getPathWithQueryParameters());
            if (this.loginView != null) {
                beforeEnterEvent.forwardTo(this.loginView);
            } else {
                beforeEnterEvent.rerouteToError(NotFoundException.class);
                if (this.loginUrl != null) {
                    beforeEnterEvent.getUI().getPage().setLocation(this.loginUrl);
                }
            }
        } else if (this.isProductionMode(beforeEnterEvent)) {
            beforeEnterEvent.rerouteToError(NotFoundException.class);
        } else {
            beforeEnterEvent.rerouteToError(NotFoundException.class, "Access denied");
        }
    }

    private boolean isProductionMode(BeforeEnterEvent beforeEnterEvent) {
        return beforeEnterEvent.getUI().getSession().getConfiguration().isProductionMode();
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

