/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PwaHandler
implements RequestHandler {
    public static final String SW_RUNTIME_PRECACHE_PATH = "/sw-runtime-resources-precache.js";
    public static final String DEFAULT_OFFLINE_STUB_PATH = "offline-stub.html";
    private final Map<String, RequestHandler> requestHandlerMap = new HashMap<String, RequestHandler>();
    private final SerializableSupplier<PwaRegistry> pwaRegistryGetter;
    private boolean isInitialized;

    public PwaHandler(SerializableSupplier<PwaRegistry> pwaRegistryGetter) {
        this.pwaRegistryGetter = pwaRegistryGetter;
    }

    private void init(PwaRegistry pwaRegistry) {
        for (PwaIcon icon : pwaRegistry.getIcons()) {
            this.requestHandlerMap.put(icon.getRelHref(), (session, request, response) -> {
                response.setContentType(icon.getType());
                if (icon.shouldBeCached()) {
                    response.setHeader("Cache-Control", "no-cache, must-revalidate");
                }
                try (OutputStream out = response.getOutputStream();){
                    icon.write(out);
                }
                return true;
            });
        }
        ArrayList<String> offlinePaths = new ArrayList<String>();
        if (pwaRegistry.getPwaConfiguration().isOfflinePathEnabled()) {
            offlinePaths.add(pwaRegistry.getPwaConfiguration().relOfflinePath());
        }
        offlinePaths.add("/offline-stub.html");
        for (String offlinePath : offlinePaths) {
            this.requestHandlerMap.put(offlinePath, (session, request, response) -> {
                response.setContentType("text/html");
                try (PrintWriter writer = response.getWriter();){
                    writer.write(pwaRegistry.getOfflineHtml());
                }
                return true;
            });
        }
        this.requestHandlerMap.put(pwaRegistry.getPwaConfiguration().relManifestPath(), (session, request, response) -> {
            response.setContentType("application/manifest+json");
            try (PrintWriter writer = response.getWriter();){
                writer.write(pwaRegistry.getManifestJson());
            }
            return true;
        });
        this.requestHandlerMap.put(SW_RUNTIME_PRECACHE_PATH, (session, request, response) -> {
            response.setContentType("application/javascript");
            try (PrintWriter writer = response.getWriter();){
                writer.write(pwaRegistry.getRuntimeServiceWorkerJs());
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        PwaRegistry pwaRegistry = (PwaRegistry)this.pwaRegistryGetter.get();
        boolean hasPwa = pwaRegistry != null && pwaRegistry.getPwaConfiguration().isEnabled();
        RequestHandler handler = null;
        session.lock();
        try {
            if (this.isInitialized && !hasPwa) {
                this.requestHandlerMap.clear();
            } else if (!this.isInitialized && hasPwa) {
                this.init(pwaRegistry);
            }
            if (hasPwa) {
                handler = this.requestHandlerMap.get(request.getPathInfo());
            }
        }
        finally {
            session.unlock();
        }
        if (handler == null) {
            return false;
        }
        return handler.handleRequest(session, request, response);
    }
}

