/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.VersionsJsonConverter;
import com.vaadin.flow.server.frontend.VersionsJsonFilter;
import com.vaadin.flow.server.frontend.WebpackPluginsUtil;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.Json;
import elemental.json.JsonException;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeUpdater
implements FallibleCommand {
    public static final String GENERATED_PREFIX = "GENERATED/";
    static final String DEPENDENCIES = "dependencies";
    static final String VAADIN_DEP_KEY = "vaadin";
    static final String HASH_KEY = "hash";
    static final String DEV_DEPENDENCIES = "devDependencies";
    private static final String DEP_LICENSE_KEY = "license";
    private static final String DEP_LICENSE_DEFAULT = "UNLICENSED";
    private static final String DEP_NAME_KEY = "name";
    private static final String DEP_NAME_DEFAULT = "no-name";
    private static final String DEP_MAIN_KEY = "main";
    protected static final String DEP_NAME_FLOW_DEPS = "@vaadin/flow-deps";
    protected static final String DEP_NAME_FLOW_JARS = "@vaadin/flow-frontend";
    protected static final String DEP_NAME_FORM_JARS = "@vaadin/form";
    private static final String FORM_FOLDER = "form";
    private static final String DEP_MAIN_VALUE = "index";
    private static final String DEP_VERSION_KEY = "version";
    private static final String DEP_VERSION_DEFAULT = "1.0.0";
    private static final String ROUTER_VERSION = "1.7.4";
    protected static final String POLYMER_VERSION = "3.2.0";
    protected final File npmFolder;
    protected final File nodeModulesFolder;
    protected final File generatedFolder;
    protected final File flowResourcesFolder;
    protected final File formResourcesFolder;
    protected final FrontendDependenciesScanner frontDeps;
    protected String buildDir;
    final ClassFinder finder;
    boolean modified;

    protected NodeUpdater(ClassFinder finder, FrontendDependenciesScanner frontendDependencies, File npmFolder, File generatedPath, File flowResourcesPath, String buildDir) {
        this.frontDeps = frontendDependencies;
        this.finder = finder;
        this.npmFolder = npmFolder;
        this.nodeModulesFolder = new File(npmFolder, "node_modules/");
        this.generatedFolder = generatedPath;
        this.flowResourcesFolder = flowResourcesPath;
        this.formResourcesFolder = new File(flowResourcesPath, FORM_FOLDER);
        this.buildDir = buildDir;
    }

    private File getPackageJsonFile() {
        return new File(this.npmFolder, "package.json");
    }

    JsonObject getPlatformPinnedDependencies() throws IOException {
        URL resource = this.finder.getResource("vaadin_versions.json");
        if (resource == null) {
            this.log().info("Couldn't find {} file to pin dependency versions. Transitive dependencies won't be pinned for pnpm.", (Object)"vaadin_versions.json");
        }
        JsonObject versionsJson = null;
        try (InputStream content = resource == null ? null : resource.openStream();){
            if (content != null) {
                VersionsJsonConverter convert = new VersionsJsonConverter(Json.parse((String)IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8)));
                versionsJson = convert.getConvertedJson();
                versionsJson = new VersionsJsonFilter(this.getPackageJson(), DEPENDENCIES).getFilteredVersions(versionsJson);
            }
        }
        return versionsJson;
    }

    static Set<String> getGeneratedModules(File directory, Set<String> excludes) {
        if (!directory.exists()) {
            return Collections.emptySet();
        }
        Function<String, String> unixPath = str -> str.replace("\\", "/");
        URI baseDir = directory.toURI();
        return FileUtils.listFiles((File)directory, (String[])new String[]{"js"}, (boolean)true).stream().filter(file -> {
            String path = (String)unixPath.apply(file.getPath());
            if (path.contains("/node_modules/")) {
                return false;
            }
            return excludes.stream().noneMatch(postfix -> path.endsWith((String)unixPath.apply((String)postfix)));
        }).map(file -> GENERATED_PREFIX + (String)unixPath.apply(baseDir.relativize(file.toURI()).getPath())).collect(Collectors.toSet());
    }

    String resolveResource(String importPath) {
        String resource;
        String resolved = importPath;
        if (!importPath.startsWith("@") && this.hasMetaInfResource(resource = resolved.replaceFirst("^\\./+", ""))) {
            if (!resolved.startsWith("./")) {
                this.log().warn("Use the './' prefix for files in JAR files: '{}', please update your component.", (Object)importPath);
            }
            resolved = "@vaadin/flow-frontend/" + resource;
        }
        return resolved;
    }

    private boolean hasMetaInfResource(String resource) {
        return this.finder.getResource("META-INF/frontend/" + resource) != null || this.finder.getResource("META-INF/resources/frontend/" + resource) != null;
    }

    JsonObject getPackageJson() throws IOException {
        JsonObject packageJson = NodeUpdater.getJsonFileContent(this.getPackageJsonFile());
        if (packageJson == null) {
            packageJson = Json.createObject();
            packageJson.put(DEP_NAME_KEY, DEP_NAME_DEFAULT);
            packageJson.put(DEP_LICENSE_KEY, DEP_LICENSE_DEFAULT);
        }
        this.addDefaultObjects(packageJson);
        NodeUpdater.addVaadinDefaultsToJson(packageJson);
        this.addWebpackPlugins(packageJson);
        return packageJson;
    }

    private void addDefaultObjects(JsonObject json) {
        NodeUpdater.computeIfAbsent(json, DEPENDENCIES, Json::createObject);
        NodeUpdater.computeIfAbsent(json, DEV_DEPENDENCIES, Json::createObject);
    }

    private void addWebpackPlugins(JsonObject packageJson) {
        JsonObject devDependencies;
        List<String> plugins = WebpackPluginsUtil.getPlugins();
        Path targetFolder = Paths.get(this.npmFolder.toString(), this.buildDir, "plugins");
        if (packageJson.hasKey(DEV_DEPENDENCIES)) {
            devDependencies = packageJson.getObject(DEV_DEPENDENCIES);
        } else {
            devDependencies = Json.createObject();
            packageJson.put(DEV_DEPENDENCIES, (JsonValue)devDependencies);
        }
        plugins.stream().filter(plugin -> targetFolder.toFile().exists()).forEach(plugin -> {
            String pluginTarget = "./" + (this.npmFolder.toPath().relativize(targetFolder).toString() + "/" + plugin).replace('\\', '/');
            devDependencies.put("@vaadin/" + plugin, pluginTarget);
        });
    }

    JsonObject getResourcesPackageJson() throws IOException {
        JsonObject packageJson = NodeUpdater.getJsonFileContent(new File(this.flowResourcesFolder, "package.json"));
        if (packageJson == null) {
            packageJson = Json.createObject();
            packageJson.put(DEP_NAME_KEY, DEP_NAME_FLOW_JARS);
            packageJson.put(DEP_LICENSE_KEY, DEP_LICENSE_DEFAULT);
            packageJson.put(DEP_MAIN_KEY, DEP_MAIN_VALUE);
            packageJson.put(DEP_VERSION_KEY, DEP_VERSION_DEFAULT);
        }
        return packageJson;
    }

    JsonObject getFormResourcesPackageJson() throws IOException {
        JsonObject packageJson = NodeUpdater.getJsonFileContent(new File(this.formResourcesFolder, "package.json"));
        if (packageJson == null) {
            packageJson = Json.createObject();
            packageJson.put(DEP_NAME_KEY, DEP_NAME_FORM_JARS);
            packageJson.put(DEP_LICENSE_KEY, DEP_LICENSE_DEFAULT);
            packageJson.put(DEP_MAIN_KEY, DEP_MAIN_VALUE);
            packageJson.put(DEP_VERSION_KEY, DEP_VERSION_DEFAULT);
            packageJson.put("sideEffects", false);
        }
        return packageJson;
    }

    static JsonObject getJsonFileContent(File packageFile) throws IOException {
        JsonObject jsonContent = null;
        if (packageFile.exists()) {
            String fileContent = FileUtils.readFileToString((File)packageFile, (String)StandardCharsets.UTF_8.name());
            try {
                jsonContent = Json.parse((String)fileContent);
            }
            catch (JsonException e) {
                throw new JsonException(String.format("Cannot parse package file '%s'", packageFile));
            }
        }
        return jsonContent;
    }

    static void addVaadinDefaultsToJson(JsonObject json) {
        JsonObject vaadinPackages = NodeUpdater.computeIfAbsent(json, VAADIN_DEP_KEY, Json::createObject);
        NodeUpdater.computeIfAbsent(vaadinPackages, DEPENDENCIES, () -> {
            JsonObject dependencies = Json.createObject();
            NodeUpdater.getDefaultDependencies().forEach((arg_0, arg_1) -> ((JsonObject)dependencies).put(arg_0, arg_1));
            return dependencies;
        });
        NodeUpdater.computeIfAbsent(vaadinPackages, DEV_DEPENDENCIES, () -> {
            JsonObject devDependencies = Json.createObject();
            NodeUpdater.getDefaultDevDependencies().forEach((arg_0, arg_1) -> ((JsonObject)devDependencies).put(arg_0, arg_1));
            return devDependencies;
        });
        NodeUpdater.computeIfAbsent(vaadinPackages, HASH_KEY, () -> Json.create((String)""));
    }

    private static <T extends JsonValue> T computeIfAbsent(JsonObject jsonObject, String key, Supplier<T> valueSupplier) {
        JsonValue result = jsonObject.get(key);
        if (result == null) {
            result = (JsonValue)valueSupplier.get();
            jsonObject.put(key, result);
        }
        return (T)result;
    }

    static Map<String, String> getDefaultDependencies() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("@vaadin/router", ROUTER_VERSION);
        defaults.put("@polymer/polymer", POLYMER_VERSION);
        defaults.put("lit", "2.0.0");
        defaults.put("construct-style-sheets-polyfill", "2.4.16");
        return defaults;
    }

    static Map<String, String> getDefaultDevDependencies() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("html-webpack-plugin", "4.5.1");
        defaults.put("typescript", "4.3.3");
        defaults.put("ts-loader", "8.0.12");
        defaults.put("fork-ts-checker-webpack-plugin", "6.2.1");
        defaults.put("webpack", "4.46.0");
        defaults.put("webpack-cli", "3.3.12");
        defaults.put("webpack-dev-server", "3.11.0");
        defaults.put("compression-webpack-plugin", "4.0.1");
        defaults.put("extra-watch-webpack-plugin", "1.0.3");
        defaults.put("webpack-merge", "4.2.2");
        defaults.put("css-loader", "4.2.1");
        defaults.put("extract-loader", "5.1.0");
        defaults.put("lit-css-loader", "0.1.0");
        defaults.put("file-loader", "6.2.0");
        defaults.put("loader-utils", "2.0.0");
        String WORKBOX_VERSION = "6.2.0";
        defaults.put("workbox-webpack-plugin", "6.2.0");
        defaults.put("workbox-core", "6.2.0");
        defaults.put("workbox-precaching", "6.2.0");
        defaults.put("glob", "7.1.6");
        defaults.put("webpack-manifest-plugin", "3.0.0");
        defaults.put("@types/validator", "13.1.0");
        defaults.put("validator", "13.1.17");
        defaults.put("chokidar", "^3.5.0");
        return defaults;
    }

    boolean updateDefaultDependencies(JsonObject packageJson) {
        int added = 0;
        for (Map.Entry<String, String> entry : NodeUpdater.getDefaultDependencies().entrySet()) {
            added += this.addDependency(packageJson, DEPENDENCIES, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : NodeUpdater.getDefaultDevDependencies().entrySet()) {
            added += this.addDependency(packageJson, DEV_DEPENDENCIES, entry.getKey(), entry.getValue());
        }
        if (added > 0) {
            this.log().info("Added {} default dependencies to main package.json", (Object)added);
        }
        return added > 0;
    }

    int addDependency(JsonObject json, String key, String pkg, String version) {
        Objects.requireNonNull(json, "Json object need to be given");
        Objects.requireNonNull(key, "Json sub object needs to be give.");
        Objects.requireNonNull(pkg, "dependency package needs to be defined");
        JsonObject vaadinDeps = json.getObject(VAADIN_DEP_KEY);
        if (!json.hasKey(key)) {
            json.put(key, (JsonValue)Json.createObject());
        }
        json = (JsonObject)json.get(key);
        if ((vaadinDeps = vaadinDeps.getObject(key)).hasKey(pkg)) {
            if (version == null) {
                version = vaadinDeps.getString(pkg);
            }
            return this.handleExistingVaadinDep(json, pkg, version, vaadinDeps);
        }
        vaadinDeps.put(pkg, version);
        if (!json.hasKey(pkg) || new FrontendVersion(version).isNewerThan(NodeUpdater.toVersion(json, pkg))) {
            json.put(pkg, version);
            this.log().debug("Added \"{}\": \"{}\" line.", (Object)pkg, (Object)version);
            return 1;
        }
        return 0;
    }

    private int handleExistingVaadinDep(JsonObject json, String pkg, String version, JsonObject vaadinDeps) {
        boolean added = false;
        FrontendVersion vaadinVersion = NodeUpdater.toVersion(vaadinDeps, pkg);
        if (json.hasKey(pkg)) {
            FrontendVersion packageVersion = NodeUpdater.toVersion(json, pkg);
            FrontendVersion newVersion = new FrontendVersion(version);
            if (vaadinVersion.isEqualTo(packageVersion) && !vaadinVersion.isEqualTo(newVersion)) {
                json.put(pkg, version);
                added = true;
            } else if (newVersion.isNewerThan(packageVersion)) {
                json.put(pkg, version);
                added = true;
            }
        } else {
            json.put(pkg, version);
            added = true;
        }
        vaadinDeps.put(pkg, version);
        if (added) {
            this.log().debug("Added \"{}\": \"{}\" line.", (Object)pkg, (Object)version);
        } else {
            added = !vaadinVersion.isEqualTo(new FrontendVersion(version));
        }
        return added ? 1 : 0;
    }

    private static FrontendVersion toVersion(JsonObject json, String key) {
        return new FrontendVersion(json.getString(key));
    }

    String writePackageFile(JsonObject packageJson) throws IOException {
        return this.writePackageFile(packageJson, new File(this.npmFolder, "package.json"));
    }

    String writeResourcesPackageFile(JsonObject packageJson) throws IOException {
        return this.writePackageFile(packageJson, new File(this.flowResourcesFolder, "package.json"));
    }

    String writeFormResourcesPackageFile(JsonObject packageJson) throws IOException {
        return this.writePackageFile(packageJson, new File(this.formResourcesFolder, "package.json"));
    }

    String writePackageFile(JsonObject json, File packageFile) throws IOException {
        this.log().debug("writing file {}.", (Object)packageFile.getAbsolutePath());
        FileUtils.forceMkdirParent((File)packageFile);
        String content = JsonUtil.stringify((JsonValue)json, (int)2) + "\n";
        FileUtils.writeStringToFile((File)packageFile, (String)content, (String)StandardCharsets.UTF_8.name());
        return content;
    }

    Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

