/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.handler;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.hilla.BrowserCallable;
import com.vaadin.hilla.EndpointInvocationException;
import com.vaadin.hilla.signals.Signal;
import com.vaadin.hilla.signals.core.registry.SecureSignalsRegistry;
import reactor.core.publisher.Flux;

@AnonymousAllowed
@BrowserCallable
public class SignalsHandler {
    private final SecureSignalsRegistry registry;

    public SignalsHandler(SecureSignalsRegistry registry) {
        this.registry = registry;
    }

    public Flux<ObjectNode> subscribe(String providerEndpoint, String providerMethod, String clientSignalId, ObjectNode body) {
        try {
            Signal<?> signal = this.registry.get(clientSignalId);
            if (signal != null) {
                return signal.subscribe().doFinally(event -> this.registry.unsubscribe(clientSignalId));
            }
            this.registry.register(clientSignalId, providerEndpoint, providerMethod, body);
            return this.registry.get(clientSignalId).subscribe().doFinally(event -> this.registry.unsubscribe(clientSignalId));
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    public void update(String clientSignalId, ObjectNode event) throws EndpointInvocationException.EndpointAccessDeniedException, EndpointInvocationException.EndpointNotFoundException {
        if (this.registry.get(clientSignalId) == null) {
            throw new IllegalStateException(String.format("Signal not found for client signal: %s", clientSignalId));
        }
        this.registry.get(clientSignalId).submit(event);
    }
}

