/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.models;

import com.vaadin.hilla.parser.models.AnnotationInfoModel;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.MethodInfoModel;
import com.vaadin.hilla.parser.models.MethodParameterInfoModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.models.SourceModel;
import com.vaadin.hilla.parser.models.TypeParameterModel;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.HierarchicalTypeSignature;
import io.github.classgraph.MethodInfo;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

final class MethodInfoSourceModel
extends MethodInfoModel
implements SourceModel {
    private final MethodInfo origin;

    MethodInfoSourceModel(MethodInfo origin) {
        this.origin = origin;
    }

    public MethodInfo get() {
        return this.origin;
    }

    @Override
    public String getClassName() {
        return this.origin.getClassName();
    }

    @Override
    public int getModifiers() {
        return this.origin.getModifiers();
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    public boolean isAbstract() {
        return this.origin.isAbstract();
    }

    @Override
    public boolean isBridge() {
        return this.origin.isBridge();
    }

    @Override
    public boolean isConstructor() {
        return this.origin.isConstructor();
    }

    @Override
    public boolean isFinal() {
        return this.origin.isFinal();
    }

    @Override
    public boolean isNative() {
        return this.origin.isNative();
    }

    @Override
    public boolean isPrivate() {
        return this.origin.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return this.origin.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.origin.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.origin.isStatic();
    }

    @Override
    public boolean isStrict() {
        return this.origin.isStrict();
    }

    @Override
    public boolean isSynchronized() {
        return this.origin.isSynchronized();
    }

    @Override
    public boolean isSynthetic() {
        return this.origin.isSynthetic();
    }

    @Override
    public boolean isVarArgs() {
        return this.origin.isVarArgs();
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return MethodInfoSourceModel.processAnnotations((List<AnnotationInfo>)this.origin.getAnnotationInfo());
    }

    @Override
    protected ClassInfoModel prepareOwner() {
        return ClassInfoModel.of(this.origin.getClassInfo());
    }

    @Override
    protected List<MethodParameterInfoModel> prepareParameters() {
        return Arrays.stream(this.origin.getParameterInfo()).map(MethodParameterInfoModel::of).collect(Collectors.toList());
    }

    @Override
    protected SignatureModel prepareResultType() {
        return SignatureModel.of((HierarchicalTypeSignature)this.origin.getTypeSignatureOrTypeDescriptor().getResultType());
    }

    @Override
    protected List<TypeParameterModel> prepareTypeParameters() {
        return this.origin.getTypeSignatureOrTypeDescriptor().getTypeParameters().stream().map(TypeParameterModel::of).collect(Collectors.toList());
    }
}

