/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.models.jackson;

import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.vaadin.hilla.parser.models.AnnotatedModel;
import com.vaadin.hilla.parser.models.AnnotationInfoModel;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.ClassMemberModel;
import com.vaadin.hilla.parser.models.FieldInfoModel;
import com.vaadin.hilla.parser.models.MethodInfoModel;
import com.vaadin.hilla.parser.models.Model;
import com.vaadin.hilla.parser.models.NamedModel;
import com.vaadin.hilla.parser.models.OwnedModel;
import com.vaadin.hilla.parser.models.ReflectionModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.models.jackson.JacksonModel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;

public final class JacksonPropertyModel
extends JacksonModel<FieldInfoModel, MethodInfoModel, MethodInfoModel>
implements NamedModel,
OwnedModel<ClassInfoModel>,
ReflectionModel {
    private ClassInfoModel owner;
    private final List<SignatureModel> types = Stream.of(this.getGetter().map(MethodInfoModel::getResultType), this.getSetter().map(setter -> setter.getParameters().get(0).getType()), this.getField().map(FieldInfoModel::getType)).flatMap(Optional::stream).collect(Collectors.toList());

    private JacksonPropertyModel(BeanPropertyDefinition origin) {
        super(origin);
    }

    public static JacksonPropertyModel of(@NonNull BeanPropertyDefinition origin) {
        return new JacksonPropertyModel(Objects.requireNonNull(origin));
    }

    public boolean couldDeserialize() {
        return this.origin.couldDeserialize();
    }

    public List<SignatureModel> getAssociatedTypes() {
        return this.types;
    }

    public Optional<? extends ClassMemberModel> getAccessor() {
        if (this.origin.hasGetter()) {
            return this.getGetter();
        }
        if (this.origin.hasField()) {
            return this.getField();
        }
        return Optional.empty();
    }

    @Override
    public Class<? extends Model> getCommonModelClass() {
        return JacksonPropertyModel.class;
    }

    public Optional<? extends ClassMemberModel> getMutator() {
        if (this.origin.hasSetter()) {
            return this.getSetter();
        }
        if (this.origin.hasField()) {
            return this.getField();
        }
        return Optional.empty();
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    public ClassInfoModel getOwner() {
        if (this.owner == null) {
            this.owner = (ClassInfoModel)this.getPrimaryMember().getOwner();
        }
        return this.owner;
    }

    public ClassMemberModel getPrimaryMember() {
        if (this.origin.hasGetter()) {
            return (ClassMemberModel)this.getGetter().get();
        }
        if (this.origin.hasSetter()) {
            return (ClassMemberModel)this.getSetter().get();
        }
        return (ClassMemberModel)this.getField().get();
    }

    public boolean isExplicitlyIncluded() {
        return this.origin.isExplicitlyIncluded();
    }

    public String toString() {
        return "JacksonPropertyModel[" + this.origin + "]";
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return Stream.of(this.getField().map(AnnotatedModel::getAnnotations), this.getGetter().map(AnnotatedModel::getAnnotations), this.getSetter().map(m -> m.getParameters().get(0).getAnnotations())).flatMap(Optional::stream).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    protected FieldInfoModel prepareField() {
        return this.origin.hasField() ? FieldInfoModel.of(this.origin.getField().getAnnotated()) : null;
    }

    @Override
    protected MethodInfoModel prepareGetter() {
        return this.origin.hasGetter() ? MethodInfoModel.of(this.origin.getGetter().getAnnotated()) : null;
    }

    @Override
    protected MethodInfoModel prepareSetter() {
        return this.origin.hasSetter() ? MethodInfoModel.of(this.origin.getSetter().getAnnotated()) : null;
    }
}

