/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LocalOfflineKey;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.OfflineKey;
import com.vaadin.pro.licensechecker.OfflineKeyValidator;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.ProKeyValidator;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.SystemBrowser;
import com.vaadin.pro.licensechecker.VaadinComIntegration;
import java.awt.HeadlessException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseChecker {
    private static boolean strictOffline = false;
    static Consumer<String> systemBrowserUrlHandler = url -> {
        try {
            LicenseChecker.getLogger().info("Opening system browser to validate license. If the browser is not opened, please open " + url + " manually");
            SystemBrowser.open(url);
        }
        catch (HeadlessException e) {
            LicenseChecker.getLogger().error("You are running in a headless environment. Please open " + url + " in any browser to validate the license.");
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException e) {
            LicenseChecker.getLogger().error("Error opening system browser to validate license. Please open " + url + " manually", (Throwable)e);
        }
    };

    public static void checkLicenseFromStaticBlock(String productName, String productVersion) {
        LicenseChecker.checkLicenseFromStaticBlock(productName, productVersion, BuildType.DEVELOPMENT);
    }

    public static void checkLicenseFromStaticBlock(String productName, String productVersion, BuildType buildType) {
        try {
            LicenseChecker.checkLicense(productName, productVersion, buildType);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Deprecated
    public static void checkLicense(String productName, String productVersion) {
        LicenseChecker.checkLicense(productName, productVersion, BuildType.DEVELOPMENT, systemBrowserUrlHandler);
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType) {
        LicenseChecker.checkLicense(productName, productVersion, buildType, systemBrowserUrlHandler);
    }

    public static void checkLicense(String productName, String productVersion, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.checkLicense(productName, productVersion, BuildType.DEVELOPMENT, noKeyUrlHandler);
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.checkLicense(new Product(productName, productVersion), buildType, noKeyUrlHandler);
    }

    @Deprecated
    public static void checkLicenseAsync(String productName, String productVersion, Callback callback) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, BuildType.DEVELOPMENT, callback);
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, buildType, callback, systemBrowserUrlHandler);
    }

    @Deprecated
    public static void checkLicenseAsync(String productName, String productVersion, Callback callback, Consumer<String> noKeyUrlHandler) {
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler) {
        new Thread(() -> {
            try {
                LicenseChecker.checkLicense(new Product(productName, productVersion), buildType, noKeyUrlHandler);
                callback.ok();
            }
            catch (Exception e) {
                callback.failed(e);
            }
        }).start();
    }

    private static void checkLicense(Product product, BuildType buildType, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.getLogger().debug("Checking license for " + product);
        String machineId = MachineId.get();
        ProKey proKey = LocalProKey.get();
        if (proKey != null && ProKeyValidator.validate(product, proKey, machineId)) {
            return;
        }
        OfflineKey offlineKey = LocalOfflineKey.get();
        if (offlineKey != null && OfflineKeyValidator.validate(product, buildType, offlineKey, machineId)) {
            return;
        }
        if (proKey == null && (proKey = VaadinComIntegration.openBrowserAndWaitForKey(product, noKeyUrlHandler)) != null) {
            LocalProKey.write(proKey);
            if (ProKeyValidator.validate(product, proKey, machineId)) {
                return;
            }
        }
        if (!strictOffline) {
            LicenseChecker.getLogger().warn("Unable to validate the license, please check your internet connection");
            return;
        }
        throw new RuntimeException("Unable to validate the license, please check your internet connection. If you need to work offline then " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId));
    }

    public static Logger getLogger() {
        return LoggerFactory.getLogger(LicenseChecker.class);
    }

    public static void setStrictOffline(boolean strictOffline) {
        LicenseChecker.strictOffline = strictOffline;
    }

    public static interface Callback {
        public void ok();

        public void failed(Exception var1);
    }
}

