/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import elemental.json.Json;
import elemental.json.JsonException;
import elemental.json.JsonObject;
import org.slf4j.Logger;

public class OfflineKey {
    private final String username;
    private final String proKey;
    private final String subscription;
    private final String hash;
    private final long expires;
    private final boolean productionOnly;

    static OfflineKey fromJson(String jsonData) {
        try {
            JsonObject json = Json.parse((String)jsonData);
            OfflineKey proKey = new OfflineKey(json.getString("username"), json.getString("proKey"), json.getString("subscription"), Long.parseLong(json.getString("expires")), json.getBoolean("productionOnly"), json.getString("hash"));
            return proKey;
        }
        catch (JsonException e) {
            OfflineKey.getLogger().error("Unable to parse offline key from json: " + jsonData, (Throwable)e);
            return null;
        }
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

    public OfflineKey(String username, String proKey, String subscription, long expires, boolean productionOnly, String hash) {
        this.username = username;
        this.proKey = proKey;
        this.expires = expires;
        this.hash = hash;
        this.subscription = subscription;
        this.productionOnly = productionOnly;
    }

    public String getUsername() {
        return this.username;
    }

    public String getProKey() {
        return this.proKey;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public long getExpires() {
        return this.expires;
    }

    public String getHash() {
        return this.hash;
    }

    public String toJson() {
        JsonObject json = Json.createObject();
        json.put("username", this.username);
        json.put("proKey", this.proKey);
        json.put("subscription", this.subscription);
        json.put("expires", "" + this.expires);
        json.put("productionOnly", this.productionOnly);
        json.put("hash", this.hash);
        return json.toJson();
    }

    public boolean isProductionOnly() {
        return this.productionOnly;
    }
}

