/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.History;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.OfflineKey;
import com.vaadin.pro.licensechecker.Product;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import org.slf4j.Logger;

public class OfflineKeyValidator {
    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

    public static boolean isExpired(OfflineKey key) {
        return Instant.now().isAfter(Instant.ofEpochMilli(key.getExpires()));
    }

    public static boolean validate(Product product, BuildType buildType, OfflineKey offlineKey, String machineId) {
        if (offlineKey == null) {
            OfflineKeyValidator.getLogger().debug("Null offlineKey");
            throw new RuntimeException(OfflineKeyValidator.getMissingOfflineKeyMessage(machineId));
        }
        OfflineKeyValidator.getLogger().debug("Validating offline key for " + product);
        if (History.isRecentlyValidated(product)) {
            OfflineKeyValidator.getLogger().debug("Skipping check as product license was recently validated.");
            return true;
        }
        String expectedHash = OfflineKeyValidator.hash(offlineKey.getUsername(), offlineKey.getProKey(), offlineKey.getSubscription(), offlineKey.getExpires(), offlineKey.isProductionOnly(), machineId);
        if (!expectedHash.equals(offlineKey.getHash())) {
            throw new RuntimeException(OfflineKeyValidator.getInvalidOfflineKeyMessage(machineId));
        }
        if (OfflineKeyValidator.isExpired(offlineKey)) {
            throw new RuntimeException(OfflineKeyValidator.getExpiredOfflineKeyMessage(machineId));
        }
        if (offlineKey.isProductionOnly() && buildType != BuildType.PRODUCTION) {
            throw new RuntimeException(OfflineKeyValidator.getOnlyProductionMessage(machineId));
        }
        History.setLastCheckTimeNow(product);
        History.setLastSubscription(product, offlineKey.getSubscription());
        return true;
    }

    private static String getExpiredOfflineKeyMessage(String machineId) {
        return "Offline key has expired, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    private static String getOnlyProductionMessage(String machineId) {
        return "The provided offline key is only enabled for production builds, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    static String getOfflineKeyLinkMessage(String machineId) {
        return "please go to https://vaadin.com/pro/validate-license?getOfflineKey=" + machineId + " to retrieve an offline key. For troubleshooting steps, see https://vaadin.com/licensing-faq-and-troubleshooting.";
    }

    private static String getInvalidOfflineKeyMessage(String machineId) {
        return "Invalid offline key, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    private static String getMissingOfflineKeyMessage(String machineId) {
        return "No offline key, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    static String hash(String username, String proKey, String subscription, long expires, boolean productionOnly, String machineId) {
        String str = username + "&" + proKey + "&" + subscription + "&" + expires + "&" + String.valueOf(productionOnly);
        if (!productionOnly) {
            str = str + "&" + machineId;
        }
        return OfflineKeyValidator.sha1(str);
    }

    private static String sha1(String str) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] messageDigest = md.digest(str.getBytes());
            BigInteger no = new BigInteger(1, messageDigest);
            String hashtext = no.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to use SHA-1", e);
        }
    }
}

