/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.ProKeyValidator;
import com.vaadin.pro.licensechecker.Product;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.prefs.Preferences;
import org.slf4j.Logger;

public class History {
    private static final String CHECK_PREFIX = "lastcheck-";

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

    static boolean isRecentlyValidated(Product product) {
        return History.isRecentlyValidated(product, Period.ofDays(1));
    }

    static boolean isRecentlyValidated(Product product, TemporalAmount period) {
        History.getLogger().debug("Checking if license for " + product + " has recently been checked");
        Instant lastCheck = History.getLastCheckTime(product);
        if (lastCheck == null) {
            return false;
        }
        Instant now = Instant.now();
        if (lastCheck.isAfter(now)) {
            return false;
        }
        Instant nextCheck = lastCheck.plus(period);
        return now.isBefore(nextCheck);
    }

    public static Instant getLastCheckTime(Product product) {
        String lastCheckKey = History.getLastCheckKey(product);
        long lastCheck = History.getPreferences().getLong(lastCheckKey, -1L);
        if (lastCheck == -1L) {
            History.getLogger().debug("License for " + product + " has never been checked");
            return null;
        }
        Instant lastCheckInstant = Instant.ofEpochMilli(lastCheck);
        History.getLogger().debug("Last check for " + product + " was on " + lastCheckInstant);
        return lastCheckInstant;
    }

    public static String getLastSubscription(Product product) {
        String lastSubscriptionKey = History.getLastSubscriptionKey(product);
        return History.getPreferences().get(lastSubscriptionKey, "");
    }

    static long setLastCheckTimeNow(Product product) {
        History.getLogger().debug("Marking license for " + product + " as checked now");
        return History.setLastCheck(product, Instant.now());
    }

    static long setLastCheck(Product product, Instant instant) {
        History.getLogger().debug("Marking license for " + product + " as checked on " + instant);
        long timeMillis = instant.toEpochMilli();
        History.getPreferences().putLong(History.getLastCheckKey(product), timeMillis);
        return timeMillis;
    }

    public static String setLastSubscription(Product product, String subscription) {
        History.getLogger().debug("Storing subscription for " + product);
        History.getPreferences().put(History.getLastSubscriptionKey(product), subscription);
        return subscription;
    }

    private static String getLastCheckKey(Product product) {
        return CHECK_PREFIX + product.getName() + "-" + product.getVersion();
    }

    private static String getLastSubscriptionKey(Product product) {
        return History.getLastCheckKey(product) + "-subscription";
    }

    private static Preferences getPreferences() {
        return Preferences.userNodeForPackage(ProKeyValidator.class);
    }

    public static void clearAll() throws Exception {
        Preferences preferences = History.getPreferences();
        for (String key : preferences.keys()) {
            if (!key.startsWith(CHECK_PREFIX)) continue;
            preferences.remove(key);
        }
    }
}

