/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineKey {
    private String jwtData;
    private JWT jwt;

    public OfflineKey(String jwtData) throws ParseException {
        this.jwtData = jwtData;
        this.jwt = JWTParser.parse((String)jwtData);
    }

    public String getJwtData() {
        return this.jwtData;
    }

    public String getSubscription() {
        try {
            return this.jwt.getJWTClaimsSet().getStringClaim("subscription");
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
            return null;
        }
    }

    public long getExpires() {
        try {
            return this.jwt.getJWTClaimsSet().getExpirationTime().getTime();
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
            return 0L;
        }
    }

    public boolean isProductionOnly() {
        try {
            return this.jwt.getJWTClaimsSet().getBooleanClaim("prod_only");
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
            return true;
        }
    }

    public String getMachineId() {
        try {
            return this.jwt.getJWTClaimsSet().getStringClaim("machine_id");
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
            return null;
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

