/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;

public class SystemBrowser {
    public static final String JAVA_HEADLESS_PROPERTY = "java.awt.headless";

    public static void open(String location) throws IOException, URISyntaxException {
        SystemBrowser.getLogger().debug("Launching system browser with URL " + location);
        URL url = new URL(location);
        String headless = System.getProperty(JAVA_HEADLESS_PROPERTY);
        if (Boolean.valueOf(headless).booleanValue()) {
            System.setProperty(JAVA_HEADLESS_PROPERTY, "false");
            Desktop.getDesktop().browse(url.toURI());
            System.setProperty(JAVA_HEADLESS_PROPERTY, headless);
        } else {
            Desktop.getDesktop().browse(url.toURI());
        }
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

