/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseValidationException;
import com.vaadin.pro.licensechecker.PreTrial;
import java.util.Objects;

public class PreTrialLicenseValidationException
extends LicenseValidationException {
    private final PreTrial preTrial;

    public PreTrialLicenseValidationException(PreTrial preTrial) {
        super(PreTrialLicenseValidationException.computeMessage(Objects.requireNonNull(preTrial, "pre trial cannot be null")));
        this.preTrial = preTrial;
    }

    public PreTrial getPreTrial() {
        return this.preTrial;
    }

    private static String computeMessage(PreTrial preTrial) {
        String message;
        switch (preTrial.trialState) {
            case START_ALLOWED: {
                message = "Pre trial not started yet.";
                break;
            }
            case ACCESS_DENIED: {
                message = "Pre trial does not grant access to the product.";
                break;
            }
            case EXPIRED: {
                message = "Pre trial period has expired. A new pre trial can be started in " + preTrial.daysRemainingUntilRenewal + " days.";
                break;
            }
            case RUNNING: {
                message = "Pre trial is active. It will expire in " + preTrial.daysRemaining + " days.";
                break;
            }
            default: {
                message = "Pre trial state undefined.";
            }
        }
        return message;
    }
}

