/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.vaadin.flow.component.charts.model.DataSeriesItem;
import com.vaadin.flow.component.charts.model.ItemPartialFill;
import com.vaadin.flow.component.charts.model.style.Color;
import com.vaadin.flow.component.charts.util.Util;
import java.time.Instant;

public class DataSeriesItemXrange
extends DataSeriesItem {
    private Number x2;
    private ItemPartialFill partialFill;

    public DataSeriesItemXrange() {
    }

    public DataSeriesItemXrange(Number x, Number x2, Number y) {
        super(x, y);
        this.setX2(x2);
    }

    public DataSeriesItemXrange(Instant x, Instant x2, Number y) {
        super(x, y);
        this.setX2(x2);
    }

    public DataSeriesItemXrange(Number x, Number x2, Number y, Number partialFillAmount) {
        this(x, x2, y);
        this.setPartialFill(new ItemPartialFill(partialFillAmount));
    }

    public DataSeriesItemXrange(Instant x, Instant x2, Number y, Number partialFillAmount) {
        this(x, x2, y);
        this.setPartialFill(new ItemPartialFill(partialFillAmount));
    }

    public DataSeriesItemXrange(Number x, Number x2, Number y, Number partialFillAmount, Color partialFillColor) {
        this(x, x2, y);
        this.setPartialFill(new ItemPartialFill(partialFillAmount, partialFillColor));
    }

    public DataSeriesItemXrange(Instant x, Instant x2, Number y, Number partialFillAmount, Color partialFillColor) {
        this(x, x2, y);
        this.setPartialFill(new ItemPartialFill(partialFillAmount, partialFillColor));
    }

    public Number getX2() {
        return this.x2;
    }

    public void setX2(Number x2) {
        this.x2 = x2;
        this.makeCustomized();
    }

    public void setX2(Instant instant) {
        this.setX2(Util.toHighchartsTS(instant));
    }

    public ItemPartialFill getPartialFill() {
        if (this.partialFill == null) {
            this.partialFill = new ItemPartialFill();
            this.makeCustomized();
        }
        return this.partialFill;
    }

    public void setPartialFill(ItemPartialFill partialFill) {
        this.partialFill = partialFill;
        this.makeCustomized();
    }
}

