/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4);
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.vaadin.client;

public class StyleConstants {

    public static final String MARGIN_TOP = "margin-top";
    public static final String MARGIN_RIGHT = "margin-right";
    public static final String MARGIN_BOTTOM = "margin-bottom";
    public static final String MARGIN_LEFT = "margin-left";

    public static final String VERTICAL_SPACING = "vspacing";
    public static final String HORIZONTAL_SPACING = "hspacing";

    /**
     * Added to all UI components.
     */
    public static final String UI_WIDGET = "v-widget";

    /**
     * Added to all layouts to denote they are layouts.
     */
    public static final String UI_LAYOUT = "v-layout";

    public static final String MODIFIED = "v-modified";
    public static final String DISABLED = "v-disabled";

    public static final String REQUIRED = "v-required";

    public static final String REQUIRED_EXT = "-required";

    public static final String ERROR_EXT = "-error";

    /**
     * Style name and style name prefix for the error indicator element.
     *
     * @since 8.2
     */
    public static final String STYLE_NAME_ERROR_INDICATOR = "v-errorindicator";
}
