/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.FieldEvents;
import com.vaadin.event.SerializableEventListener;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.ui.Component;
import com.vaadin.ui.LegacyComponent;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.shared.ui.textfield.AbstractTextFieldState;
import com.vaadin.v7.ui.AbstractField;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

@Deprecated
public abstract class AbstractTextField
extends AbstractField<String>
implements FieldEvents.BlurNotifier,
FieldEvents.FocusNotifier,
FieldEvents.TextChangeNotifier,
LegacyComponent {
    private String nullRepresentation = "null";
    private boolean nullSettingAllowed = false;
    private String lastKnownTextContent;
    private int lastKnownCursorPosition;
    private boolean textChangeEventPending;
    private boolean isFiringTextChangeEvent = false;
    private TextChangeEventMode textChangeEventMode = TextChangeEventMode.LAZY;
    private static final int DEFAULT_TEXTCHANGE_TIMEOUT = 400;
    private int textChangeEventTimeout = 400;
    private int selectionPosition = -1;
    private int selectionLength;
    private boolean changingVariables;

    protected AbstractTextField() {
    }

    protected AbstractTextFieldState getState() {
        return (AbstractTextFieldState)super.getState();
    }

    protected AbstractTextFieldState getState(boolean markAsDirty) {
        return (AbstractTextFieldState)super.getState(markAsDirty);
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
        String value = (String)this.getValue();
        if (value == null) {
            value = this.getNullRepresentation();
        }
        this.getState().text = value;
    }

    public void paintContent(PaintTarget target) throws PaintException {
        if (this.selectionPosition != -1) {
            target.addAttribute("selpos", this.selectionPosition);
            target.addAttribute("sellen", this.selectionLength);
            this.selectionPosition = -1;
        }
        if (this.hasListeners(FieldEvents.TextChangeEvent.class)) {
            target.addAttribute("iem", this.getTextChangeEventMode().toString());
            target.addAttribute("iet", this.getTextChangeTimeout());
            if (this.lastKnownTextContent != null) {
                target.addAttribute("nvc", true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeVariables(Object source, Map<String, Object> variables) {
        this.changingVariables = true;
        try {
            String newWidth;
            String newHeight = (String)variables.get("height");
            if (newHeight != null) {
                this.setHeight(newHeight);
            }
            if ((newWidth = (String)variables.get("width")) != null) {
                this.setWidth(newWidth);
            }
            if (variables.containsKey("c")) {
                Integer object = (Integer)variables.get("c");
                this.lastKnownCursorPosition = object;
            }
            if (variables.containsKey("curText")) {
                this.handleInputEventTextChange(variables);
            }
            if (variables.containsKey("text") && !this.isReadOnly()) {
                String newValue = (String)variables.get("text");
                if (this.getMaxLength() != -1 && newValue.length() > this.getMaxLength()) {
                    newValue = newValue.substring(0, this.getMaxLength());
                }
                String oldValue = (String)this.getValue();
                if (newValue != null && (oldValue == null || this.isNullSettingAllowed()) && newValue.equals(this.getNullRepresentation())) {
                    newValue = null;
                }
                if (!(newValue == oldValue || newValue != null && newValue.equals(oldValue))) {
                    boolean wasModified = this.isModified();
                    this.setValue(newValue, true);
                    if (wasModified != this.isModified()) {
                        this.markAsDirty();
                    }
                }
            }
            this.firePendingTextChangeEvent();
            if (variables.containsKey("focus")) {
                this.fireEvent((EventObject)new FieldEvents.FocusEvent((Component)this));
            }
            if (variables.containsKey("blur")) {
                this.fireEvent((EventObject)new FieldEvents.BlurEvent((Component)this));
            }
        }
        finally {
            this.changingVariables = false;
        }
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    public String getNullRepresentation() {
        return this.nullRepresentation;
    }

    public boolean isNullSettingAllowed() {
        return this.nullSettingAllowed;
    }

    public void setNullRepresentation(String nullRepresentation) {
        this.nullRepresentation = nullRepresentation;
        this.markAsDirty();
    }

    public void setNullSettingAllowed(boolean nullSettingAllowed) {
        this.nullSettingAllowed = nullSettingAllowed;
        this.markAsDirty();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() || ((String)this.getValue()).isEmpty();
    }

    public int getMaxLength() {
        return this.getState((boolean)false).maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.getState().maxLength = maxLength;
    }

    public int getColumns() {
        return this.getState((boolean)false).columns;
    }

    public void setColumns(int columns) {
        if (columns < 0) {
            columns = 0;
        }
        this.getState().columns = columns;
    }

    public String getInputPrompt() {
        return this.getState((boolean)false).inputPrompt;
    }

    public void setInputPrompt(String inputPrompt) {
        this.getState().inputPrompt = inputPrompt;
    }

    private void firePendingTextChangeEvent() {
        if (this.textChangeEventPending && !this.isFiringTextChangeEvent) {
            this.isFiringTextChangeEvent = true;
            this.textChangeEventPending = false;
            try {
                this.fireEvent((EventObject)((Object)new TextChangeEventImpl(this)));
            }
            finally {
                this.isFiringTextChangeEvent = false;
            }
        }
    }

    @Override
    protected void setInternalValue(String newValue) {
        if (this.changingVariables && !this.textChangeEventPending) {
            if (newValue == null && this.lastKnownTextContent != null && !this.lastKnownTextContent.equals(this.getNullRepresentation())) {
                this.lastKnownTextContent = this.getNullRepresentation();
                this.textChangeEventPending = true;
            } else if (newValue != null && !newValue.equals(this.lastKnownTextContent)) {
                this.lastKnownTextContent = newValue;
                this.textChangeEventPending = true;
            }
            this.firePendingTextChangeEvent();
        }
        super.setInternalValue(newValue);
    }

    @Override
    public void setValue(String newValue) throws Property.ReadOnlyException {
        super.setValue(newValue);
        if (this.lastKnownTextContent != null) {
            this.lastKnownTextContent = null;
            this.markAsDirty();
        }
    }

    private void handleInputEventTextChange(Map<String, Object> variables) {
        String object;
        this.lastKnownTextContent = object = (String)variables.get("curText");
        this.textChangeEventPending = true;
    }

    public void setTextChangeEventMode(TextChangeEventMode inputEventMode) {
        this.textChangeEventMode = inputEventMode;
        this.markAsDirty();
    }

    public TextChangeEventMode getTextChangeEventMode() {
        return this.textChangeEventMode;
    }

    @Override
    public void addTextChangeListener(FieldEvents.TextChangeListener listener) {
        this.addListener("ie", FieldEvents.TextChangeEvent.class, (SerializableEventListener)listener, FieldEvents.TextChangeListener.EVENT_METHOD);
    }

    @Deprecated
    public void addListener(FieldEvents.TextChangeListener listener) {
        this.addTextChangeListener(listener);
    }

    @Override
    public void removeTextChangeListener(FieldEvents.TextChangeListener listener) {
        this.removeListener("ie", FieldEvents.TextChangeEvent.class, listener);
    }

    @Deprecated
    public void removeListener(FieldEvents.TextChangeListener listener) {
        this.removeTextChangeListener(listener);
    }

    public void setTextChangeTimeout(int timeout) {
        this.textChangeEventTimeout = timeout;
        this.markAsDirty();
    }

    public int getTextChangeTimeout() {
        return this.textChangeEventTimeout;
    }

    private String getCurrentTextContent() {
        if (this.lastKnownTextContent != null) {
            return this.lastKnownTextContent;
        }
        Object text = this.getValue();
        if (text == null) {
            return this.getNullRepresentation();
        }
        return text.toString();
    }

    public void selectAll() {
        String text = this.getValue() == null ? "" : (String)this.getValue();
        this.setSelectionRange(0, text.length());
    }

    public void setSelectionRange(int pos, int length) {
        this.selectionPosition = pos;
        this.selectionLength = length;
        this.focus();
        this.markAsDirty();
    }

    public void setCursorPosition(int pos) {
        this.setSelectionRange(pos, 0);
        this.lastKnownCursorPosition = pos;
    }

    public int getCursorPosition() {
        return this.lastKnownCursorPosition;
    }

    @Override
    public void addFocusListener(FieldEvents.FocusListener listener) {
        this.addListener("focus", FieldEvents.FocusEvent.class, (SerializableEventListener)listener, FieldEvents.FocusListener.focusMethod);
    }

    @Deprecated
    public void addListener(FieldEvents.FocusListener listener) {
        this.addFocusListener(listener);
    }

    @Override
    public void removeFocusListener(FieldEvents.FocusListener listener) {
        this.removeListener("focus", FieldEvents.FocusEvent.class, listener);
    }

    @Deprecated
    public void removeListener(FieldEvents.FocusListener listener) {
        this.removeFocusListener(listener);
    }

    @Override
    public void addBlurListener(FieldEvents.BlurListener listener) {
        this.addListener("blur", FieldEvents.BlurEvent.class, (SerializableEventListener)listener, FieldEvents.BlurListener.blurMethod);
    }

    @Deprecated
    public void addListener(FieldEvents.BlurListener listener) {
        this.addBlurListener(listener);
    }

    @Override
    public void removeBlurListener(FieldEvents.BlurListener listener) {
        this.removeListener("blur", FieldEvents.BlurEvent.class, listener);
    }

    @Deprecated
    public void removeListener(FieldEvents.BlurListener listener) {
        this.removeBlurListener(listener);
    }

    @Override
    public void readDesign(Element design, DesignContext designContext) {
        super.readDesign(design, designContext);
        Attributes attr = design.attributes();
        if (attr.hasKey("maxlength")) {
            this.setMaxLength((Integer)DesignAttributeHandler.readAttribute((String)"maxlength", (Attributes)attr, Integer.class));
        }
    }

    @Override
    protected Collection<String> getCustomAttributes() {
        Collection<String> customAttributes = super.getCustomAttributes();
        customAttributes.add("maxlength");
        customAttributes.add("max-length");
        customAttributes.add("cursor-position");
        return customAttributes;
    }

    @Override
    public void writeDesign(Element design, DesignContext designContext) {
        super.writeDesign(design, designContext);
        AbstractTextField def = (AbstractTextField)designContext.getDefaultInstance((Component)this);
        Attributes attr = design.attributes();
        DesignAttributeHandler.writeAttribute((String)"maxlength", (Attributes)attr, (Object)this.getMaxLength(), (Object)def.getMaxLength(), Integer.class, (DesignContext)designContext);
    }

    @Deprecated
    public static class TextChangeEventImpl
    extends FieldEvents.TextChangeEvent {
        private String curText;
        private int cursorPosition;

        private TextChangeEventImpl(AbstractTextField tf) {
            super((Component)tf);
            this.curText = tf.getCurrentTextContent();
            this.cursorPosition = tf.getCursorPosition();
        }

        public AbstractTextField getComponent() {
            return (AbstractTextField)super.getComponent();
        }

        @Override
        public String getText() {
            return this.curText;
        }

        @Override
        public int getCursorPosition() {
            return this.cursorPosition;
        }
    }

    @Deprecated
    public static enum TextChangeEventMode {
        EAGER,
        TIMEOUT,
        LAZY;

    }
}

