/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui.components.calendar;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.components.calendar.CalendarComponentEvents;
import com.vaadin.v7.ui.components.calendar.event.BasicEvent;
import com.vaadin.v7.ui.components.calendar.event.CalendarEditableEventProvider;
import com.vaadin.v7.ui.components.calendar.event.CalendarEvent;
import com.vaadin.v7.ui.components.calendar.event.CalendarEventProvider;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

@Deprecated
public class ContainerEventProvider
implements CalendarEditableEventProvider,
CalendarEventProvider.EventSetChangeNotifier,
CalendarEvent.EventChangeNotifier,
CalendarComponentEvents.EventMoveHandler,
CalendarComponentEvents.EventResizeHandler,
Container.ItemSetChangeListener,
Property.ValueChangeListener {
    public static final String CAPTION_PROPERTY = "caption";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String STARTDATE_PROPERTY = "start";
    public static final String ENDDATE_PROPERTY = "end";
    public static final String STYLENAME_PROPERTY = "styleName";
    public static final String ALL_DAY_PROPERTY = "allDay";
    private final List<CalendarEventProvider.EventSetChangeListener> eventSetChangeListeners = new LinkedList<CalendarEventProvider.EventSetChangeListener>();
    private final List<CalendarEvent.EventChangeListener> eventChangeListeners = new LinkedList<CalendarEvent.EventChangeListener>();
    private final List<CalendarEvent> eventCache = new LinkedList<CalendarEvent>();
    private Container.Indexed container;
    private Object captionProperty = "caption";
    private Object descriptionProperty = "description";
    private Object startDateProperty = "start";
    private Object endDateProperty = "end";
    private Object styleNameProperty = "styleName";
    private Object allDayProperty = "allDay";

    public ContainerEventProvider(Container.Indexed container) {
        this.container = container;
        this.listenToContainerEvents();
    }

    public void setContainerDataSource(Container.Indexed container) {
        this.detachContainerDataSource();
        this.container = container;
        this.listenToContainerEvents();
    }

    public Container.Indexed getContainerDataSource() {
        return this.container;
    }

    private void listenToContainerEvents() {
        if (this.container instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.container)).addItemSetChangeListener(this);
        }
        if (this.container instanceof Property.ValueChangeNotifier) {
            ((Property.ValueChangeNotifier)((Object)this.container)).addValueChangeListener(this);
        }
    }

    private void ignoreContainerEvents() {
        if (this.container instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.container)).removeItemSetChangeListener(this);
        }
        if (this.container instanceof Property.ValueChangeNotifier) {
            ((Property.ValueChangeNotifier)((Object)this.container)).removeValueChangeListener(this);
        }
    }

    private CalendarEvent getEvent(int index) {
        CalendarEvent event;
        for (CalendarEvent e : this.eventCache) {
            if (e instanceof ContainerCalendarEvent && ((ContainerCalendarEvent)e).getContainerIndex() == index) {
                return e;
            }
            if (this.container.getIdByIndex(index) != e) continue;
            return e;
        }
        Object id = this.container.getIdByIndex(index);
        Item item = this.container.getItem(id);
        if (id instanceof CalendarEvent) {
            event = (CalendarEvent)id;
        } else {
            ContainerCalendarEvent basicEvent = new ContainerCalendarEvent(index);
            if (this.captionProperty != null && item.getItemPropertyIds().contains(this.captionProperty)) {
                basicEvent.setCaption(String.valueOf(item.getItemProperty(this.captionProperty).getValue()));
            }
            if (this.descriptionProperty != null && item.getItemPropertyIds().contains(this.descriptionProperty)) {
                basicEvent.setDescription(String.valueOf(item.getItemProperty(this.descriptionProperty).getValue()));
            }
            if (this.startDateProperty != null && item.getItemPropertyIds().contains(this.startDateProperty)) {
                basicEvent.setStart((Date)item.getItemProperty(this.startDateProperty).getValue());
            }
            if (this.endDateProperty != null && item.getItemPropertyIds().contains(this.endDateProperty)) {
                basicEvent.setEnd((Date)item.getItemProperty(this.endDateProperty).getValue());
            }
            if (this.styleNameProperty != null && item.getItemPropertyIds().contains(this.styleNameProperty)) {
                basicEvent.setStyleName(String.valueOf(item.getItemProperty(this.styleNameProperty).getValue()));
            }
            if (this.allDayProperty != null && item.getItemPropertyIds().contains(this.allDayProperty)) {
                basicEvent.setAllDay((Boolean)item.getItemProperty(this.allDayProperty).getValue());
            }
            event = basicEvent;
        }
        return event;
    }

    @Override
    public List<CalendarEvent> getEvents(Date startDate, Date endDate) {
        this.eventCache.clear();
        int size = this.container.size();
        assert (size >= 0);
        for (int i = 0; i < size; ++i) {
            Date eventStart;
            Date eventEnd;
            Object id = this.container.getIdByIndex(i);
            Item item = this.container.getItem(id);
            boolean add = true;
            if (startDate != null && (eventEnd = (Date)item.getItemProperty(this.endDateProperty).getValue()).compareTo(startDate) < 0) {
                add = false;
            }
            if (add && endDate != null && (eventStart = (Date)item.getItemProperty(this.startDateProperty).getValue()).compareTo(endDate) >= 0) break;
            if (!add) continue;
            this.eventCache.add(this.getEvent(i));
        }
        return Collections.unmodifiableList(this.eventCache);
    }

    @Override
    public void addEventSetChangeListener(CalendarEventProvider.EventSetChangeListener listener) {
        if (!this.eventSetChangeListeners.contains(listener)) {
            this.eventSetChangeListeners.add(listener);
        }
    }

    @Override
    public void removeEventSetChangeListener(CalendarEventProvider.EventSetChangeListener listener) {
        this.eventSetChangeListeners.remove(listener);
    }

    @Override
    public void addEventChangeListener(CalendarEvent.EventChangeListener listener) {
        if (this.eventChangeListeners.contains(listener)) {
            this.eventChangeListeners.add(listener);
        }
    }

    @Override
    public void removeEventChangeListener(CalendarEvent.EventChangeListener listener) {
        this.eventChangeListeners.remove(listener);
    }

    public Object getCaptionProperty() {
        return this.captionProperty;
    }

    public void setCaptionProperty(Object captionProperty) {
        this.captionProperty = captionProperty;
    }

    public Object getDescriptionProperty() {
        return this.descriptionProperty;
    }

    public void setDescriptionProperty(Object descriptionProperty) {
        this.descriptionProperty = descriptionProperty;
    }

    public Object getStartDateProperty() {
        return this.startDateProperty;
    }

    public void setStartDateProperty(Object startDateProperty) {
        this.startDateProperty = startDateProperty;
    }

    public Object getEndDateProperty() {
        return this.endDateProperty;
    }

    public void setEndDateProperty(Object endDateProperty) {
        this.endDateProperty = endDateProperty;
    }

    public Object getStyleNameProperty() {
        return this.styleNameProperty;
    }

    public void setStyleNameProperty(Object styleNameProperty) {
        this.styleNameProperty = styleNameProperty;
    }

    public void setAllDayProperty(Object allDayProperty) {
        this.allDayProperty = allDayProperty;
    }

    public Object getAllDayProperty() {
        return this.allDayProperty;
    }

    @Override
    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        if (event.getContainer() == this.container) {
            for (CalendarEventProvider.EventSetChangeListener listener : this.eventSetChangeListeners) {
                listener.eventSetChange(new CalendarEventProvider.EventSetChangeEvent(this));
            }
        }
    }

    @Override
    public void valueChange(Property.ValueChangeEvent event) {
    }

    @Override
    public void eventMove(CalendarComponentEvents.MoveEvent event) {
        CalendarEvent ce = event.getCalendarEvent();
        if (this.eventCache.contains(ce)) {
            int index = ce instanceof ContainerCalendarEvent ? ((ContainerCalendarEvent)ce).getContainerIndex() : this.container.indexOfId(ce);
            long eventLength = ce.getEnd().getTime() - ce.getStart().getTime();
            Date newEnd = new Date(event.getNewStart().getTime() + eventLength);
            this.ignoreContainerEvents();
            Item item = this.container.getItem(this.container.getIdByIndex(index));
            item.getItemProperty(this.startDateProperty).setValue(event.getNewStart());
            item.getItemProperty(this.endDateProperty).setValue(newEnd);
            this.listenToContainerEvents();
        }
    }

    @Override
    public void eventResize(CalendarComponentEvents.EventResize event) {
        CalendarEvent ce = event.getCalendarEvent();
        if (this.eventCache.contains(ce)) {
            int index = ce instanceof ContainerCalendarEvent ? ((ContainerCalendarEvent)ce).getContainerIndex() : this.container.indexOfId(ce);
            this.ignoreContainerEvents();
            Item item = this.container.getItem(this.container.getIdByIndex(index));
            item.getItemProperty(this.startDateProperty).setValue(event.getNewStart());
            item.getItemProperty(this.endDateProperty).setValue(event.getNewEnd());
            this.listenToContainerEvents();
        }
    }

    public void detachContainerDataSource() {
        this.ignoreContainerEvents();
    }

    @Override
    public void addEvent(CalendarEvent event) {
        Item item;
        try {
            item = this.container.addItem(event);
        }
        catch (UnsupportedOperationException uop) {
            item = this.container.getItem(this.container.addItem());
        }
        if (item != null) {
            item.getItemProperty(this.getCaptionProperty()).setValue(event.getCaption());
            item.getItemProperty(this.getStartDateProperty()).setValue(event.getStart());
            item.getItemProperty(this.getEndDateProperty()).setValue(event.getEnd());
            item.getItemProperty(this.getStyleNameProperty()).setValue(event.getStyleName());
            item.getItemProperty(this.getDescriptionProperty()).setValue(event.getDescription());
        }
    }

    @Override
    public void removeEvent(CalendarEvent event) {
        this.container.removeItem(event);
    }

    private class ContainerCalendarEvent
    extends BasicEvent {
        private final int index;

        public ContainerCalendarEvent(int containerIndex) {
            this.index = containerIndex;
        }

        public int getContainerIndex() {
            return this.index;
        }
    }
}

