/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.contextmenu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.contextmenu.MenuManager;
import com.vaadin.flow.component.contextmenu.SubMenuBase;
import com.vaadin.flow.component.grid.contextmenu.GridContextMenu;
import com.vaadin.flow.component.grid.contextmenu.GridMenuItem;
import com.vaadin.flow.component.grid.contextmenu.HasGridMenuItems;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableRunnable;
import java.io.Serializable;
import java.util.Objects;

public class GridSubMenu<T>
extends SubMenuBase<GridContextMenu<T>, GridMenuItem<T>, GridSubMenu<T>>
implements HasGridMenuItems<T> {
    private final SerializableRunnable contentReset;

    public GridSubMenu(GridMenuItem<T> parentMenuItem, SerializableRunnable contentReset) {
        super(parentMenuItem);
        Objects.requireNonNull(parentMenuItem);
        this.contentReset = contentReset;
    }

    @Override
    public GridMenuItem<T> addItem(String text, ComponentEventListener<GridContextMenu.GridContextMenuItemClickEvent<T>> clickListener) {
        GridMenuItem menuItem = (GridMenuItem)this.addItem(text);
        if (clickListener != null) {
            menuItem.addMenuItemClickListener(clickListener);
        }
        return menuItem;
    }

    @Override
    public GridMenuItem<T> addItem(Component component, ComponentEventListener<GridContextMenu.GridContextMenuItemClickEvent<T>> clickListener) {
        GridMenuItem menuItem = (GridMenuItem)this.addItem(component);
        if (clickListener != null) {
            menuItem.addMenuItemClickListener(clickListener);
        }
        return menuItem;
    }

    protected MenuManager<GridContextMenu<T>, GridMenuItem<T>, GridSubMenu<T>> createMenuManager() {
        SerializableBiFunction & Serializable itemFactory = (SerializableBiFunction & Serializable)(menu, reset) -> new GridMenuItem((GridContextMenu)menu, (SerializableRunnable)reset);
        return new MenuManager((Component)((GridMenuItem)this.getParentMenuItem()).getContextMenu(), this.contentReset, (SerializableBiFunction)itemFactory, GridMenuItem.class, this.getParentMenuItem());
    }
}

