/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.listbox;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.listbox.ListBoxBase;
import com.vaadin.flow.component.shared.SelectionPreservationHandler;
import com.vaadin.flow.component.shared.SelectionPreservationMode;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MultiSelectListBox<T>
extends ListBoxBase<MultiSelectListBox<T>, T, Set<T>>
implements MultiSelect<MultiSelectListBox<T>, T> {
    private SelectionPreservationHandler<T> selectionPreservationHandler;

    public MultiSelectListBox() {
        super("selectedValues", JsonArray.class, Collections.emptySet(), MultiSelectListBox::presentationToModel, MultiSelectListBox::modelToPresentation);
        this.getElement().setProperty("multiple", true);
        this.initSelectionPreservationHandler();
    }

    private void initSelectionPreservationHandler() {
        this.selectionPreservationHandler = new SelectionPreservationHandler<T>(SelectionPreservationMode.DISCARD){

            public void onPreserveAll(DataChangeEvent<T> dataChangeEvent) {
            }

            public void onPreserveExisting(DataChangeEvent<T> dataChangeEvent) {
                Map<Object, Object> deselectionCandidateIdsToItems = MultiSelectListBox.this.getSelectedItems().stream().collect(Collectors.toMap(item -> MultiSelectListBox.this.getItemId(item), item -> item));
                Stream itemsStream = MultiSelectListBox.this.getDataProvider().fetch(DataViewUtils.getQuery((Component)MultiSelectListBox.this));
                Set<Object> existingItemIds = itemsStream.map(item -> MultiSelectListBox.this.getItemId(item)).filter(deselectionCandidateIdsToItems::containsKey).limit(deselectionCandidateIdsToItems.size()).collect(Collectors.toSet());
                existingItemIds.forEach(deselectionCandidateIdsToItems::remove);
                MultiSelectListBox.this.deselect(deselectionCandidateIdsToItems.values());
            }

            public void onDiscard(DataChangeEvent<T> dataChangeEvent) {
                MultiSelectListBox.this.clear();
            }
        };
    }

    private static <T> Set<T> presentationToModel(MultiSelectListBox<T> listBox, JsonArray presentation) {
        Set modelValue = IntStream.range(0, presentation.length()).map(idx -> (int)presentation.getNumber(idx)).mapToObj(index -> listBox.getItems().get(index)).collect(Collectors.toSet());
        return Collections.unmodifiableSet(modelValue);
    }

    private static <T> JsonArray modelToPresentation(MultiSelectListBox<T> listBox, Set<T> model) {
        JsonArray array = Json.createArray();
        AtomicInteger idx = new AtomicInteger(0);
        listBox.getItems().forEach(item -> {
            int index = idx.getAndIncrement();
            Object itemId = listBox.getItemId(item);
            model.stream().filter(selectedItem -> itemId.equals(listBox.getItemId(selectedItem))).findFirst().ifPresent(ignored -> array.set(array.length(), (double)index));
        });
        return array;
    }

    public void setValue(Set<T> value) {
        Objects.requireNonNull(value, "Cannot set a null value to multi select list box. Use the clear-method to reset the component's value to an empty set.");
        super.setValue(value);
    }

    public void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        HashSet<T> value = new HashSet<T>((Collection)this.getValue());
        value.addAll(addedItems);
        value.removeAll(removedItems);
        this.setValue(value);
    }

    public Set<T> getSelectedItems() {
        return (Set)this.getValue();
    }

    public Registration addSelectionListener(MultiSelectionListener<MultiSelectListBox<T>, T> listener) {
        return this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listener.selectionChange(new MultiSelectionEvent((Component)this, (HasValue)this, (Set)event.getOldValue(), event.isFromClient())));
    }

    public void setSelectionPreservationMode(SelectionPreservationMode selectionPreservationMode) {
        this.selectionPreservationHandler.setSelectionPreservationMode(selectionPreservationMode);
    }

    public SelectionPreservationMode getSelectionPreservationMode() {
        return this.selectionPreservationHandler.getSelectionPreservationMode();
    }

    @Override
    void handleDataChange(DataChangeEvent<T> dataChangeEvent) {
        if (dataChangeEvent instanceof DataChangeEvent.DataRefreshEvent) {
            super.handleDataChange(dataChangeEvent);
        } else {
            this.selectionPreservationHandler.handleDataChange(dataChangeEvent);
            this.rebuild();
        }
    }

    protected boolean valueEquals(Set<T> value1, Set<T> value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (value1.size() != value2.size()) {
            return false;
        }
        Set ids1 = value1.stream().map(x$0 -> super.getItemId(x$0)).collect(Collectors.toSet());
        Set ids2 = value2.stream().map(x$0 -> super.getItemId(x$0)).collect(Collectors.toSet());
        return ids1.equals(ids2);
    }
}

