/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.messages;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.messages.MessageList;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MessageListItem
implements Serializable {
    private MessageList host;
    private String text;
    String clientText;
    private Instant time;
    private String userName;
    private String userAbbreviation;
    private String userImage;
    private Integer userColorIndex;
    private StreamRegistration resourceRegistration;
    private Registration pendingRegistration;
    private Command pendingHandle;
    private AbstractStreamResource imageResource;
    private Set<String> themeNames = new LinkedHashSet<String>();
    private Set<String> classNames = new LinkedHashSet<String>();

    public MessageListItem() {
    }

    public MessageListItem(String text) {
        this.text = text;
    }

    public MessageListItem(String text, String userName) {
        this(text);
        this.userName = userName;
    }

    public MessageListItem(String text, Instant time, String userName) {
        this(text, userName);
        this.time = time;
    }

    public MessageListItem(String text, Instant time, String userName, String userImage) {
        this(text, time, userName);
        this.userImage = userImage;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.getHost() != null) {
            this.getHost().scheduleItemsTextUpdate();
        }
    }

    public void appendText(String text) {
        if (text == null) {
            return;
        }
        this.setText(Optional.ofNullable(this.text).orElse("") + text);
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Instant getTime() {
        return this.time;
    }

    public void setTime(Instant time) {
        this.time = time;
        this.propsChanged();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.propsChanged();
    }

    @JsonProperty(value="userAbbr")
    public String getUserAbbreviation() {
        return this.userAbbreviation;
    }

    public void setUserAbbreviation(String userAbbreviation) {
        this.userAbbreviation = userAbbreviation;
        this.propsChanged();
    }

    @JsonProperty(value="userImg")
    public String getUserImage() {
        return this.userImage;
    }

    public void setUserImage(String userImage) {
        this.unsetResource();
        this.userImage = userImage;
        this.propsChanged();
    }

    public Integer getUserColorIndex() {
        return this.userColorIndex;
    }

    public void setUserColorIndex(Integer userColorIndex) {
        this.userColorIndex = userColorIndex;
        this.propsChanged();
    }

    public void addThemeNames(String ... themeNames) {
        this.themeNames.addAll(Arrays.asList(themeNames));
        this.propsChanged();
    }

    public void removeThemeNames(String ... themeNames) {
        this.themeNames.removeAll(Arrays.asList(themeNames));
        this.propsChanged();
    }

    public boolean hasThemeName(String themeName) {
        return this.themeNames.contains(themeName);
    }

    @JsonGetter
    private String getTheme() {
        if (this.themeNames.isEmpty()) {
            return null;
        }
        return this.themeNames.stream().collect(Collectors.joining(" "));
    }

    public void addClassNames(String ... classNames) {
        this.classNames.addAll(Arrays.asList(classNames));
        this.propsChanged();
    }

    public void removeClassNames(String ... classNames) {
        this.classNames.removeAll(Arrays.asList(classNames));
        this.propsChanged();
    }

    public boolean hasClassName(String className) {
        return this.classNames.contains(className);
    }

    @JsonGetter
    private String getClassName() {
        if (this.classNames.isEmpty()) {
            return null;
        }
        return this.classNames.stream().collect(Collectors.joining(" "));
    }

    @JsonIgnore
    public AbstractStreamResource getUserImageResource() {
        return this.imageResource;
    }

    public void setUserImageHandler(DownloadHandler downloadHandler) {
        if (downloadHandler == null) {
            this.unsetResource();
            return;
        }
        if (downloadHandler instanceof AbstractDownloadHandler) {
            AbstractDownloadHandler handler = (AbstractDownloadHandler)downloadHandler;
            handler.inline();
        }
        this.setUserImageResource((AbstractStreamResource)new StreamResourceRegistry.ElementStreamResource((ElementRequestHandler)downloadHandler, this.getHost() != null ? this.getHost().getElement() : UI.getCurrent().getElement()));
    }

    @Deprecated(since="24.8", forRemoval=true)
    public void setUserImageResource(AbstractStreamResource resource) {
        this.imageResource = resource;
        if (resource == null) {
            this.unsetResource();
            return;
        }
        this.doSetResource(resource);
        if (this.getHost() != null && this.getHost().getElement().getNode().isAttached()) {
            this.registerResource(resource);
        } else {
            this.deferRegistration(resource);
        }
        this.propsChanged();
    }

    private void doSetResource(AbstractStreamResource resource) {
        URI targetUri;
        if (VaadinSession.getCurrent() != null) {
            StreamResourceRegistry resourceRegistry = VaadinSession.getCurrent().getResourceRegistry();
            targetUri = resourceRegistry.getTargetURI(resource);
        } else {
            targetUri = StreamResourceRegistry.getURI((AbstractStreamResource)resource);
        }
        this.userImage = targetUri.toASCIIString();
    }

    private void unregisterResource() {
        StreamRegistration registration = this.resourceRegistration;
        Registration handle = this.pendingRegistration;
        if (handle != null) {
            handle.remove();
        }
        if (registration != null) {
            registration.unregister();
        }
        this.userImage = null;
    }

    private void deferRegistration(AbstractStreamResource resource) {
        if (this.pendingRegistration != null) {
            return;
        }
        this.pendingHandle = (Command & Serializable)() -> {
            this.doSetResource(resource);
            this.registerResource(resource);
        };
        if (this.getHost() != null) {
            this.attachPendingRegistration(this.pendingHandle);
            this.pendingHandle = null;
        }
    }

    private void attachPendingRegistration(Command pendingHandle) {
        Registration handle;
        if (this.getHost().getElement().getNode().isAttached()) {
            pendingHandle.execute();
            return;
        }
        this.pendingRegistration = handle = this.getHost().getElement().getNode().addAttachListener(pendingHandle);
    }

    private void registerResource(AbstractStreamResource resource) {
        StreamRegistration registration;
        assert (this.resourceRegistration == null);
        this.resourceRegistration = registration = this.getSession().getResourceRegistry().registerResource(resource);
        Registration handle = this.pendingRegistration;
        if (handle != null) {
            handle.remove();
        }
        this.pendingRegistration = this.getHost().getElement().getNode().addDetachListener(new Command(){

            public void execute() {
                MessageListItem.this.unsetResource();
            }
        });
    }

    private void unsetResource() {
        this.imageResource = null;
        StreamRegistration registration = this.resourceRegistration;
        Optional<AbstractStreamResource> resource = Optional.empty();
        if (registration != null) {
            resource = Optional.ofNullable(registration.getResource());
        }
        this.unregisterResource();
        resource.ifPresent(this::deferRegistration);
    }

    private VaadinSession getSession() {
        NodeOwner owner = this.getHost().getElement().getNode().getOwner();
        assert (owner instanceof StateTree);
        return ((StateTree)owner).getUI().getSession();
    }

    private void propsChanged() {
        if (this.getHost() != null) {
            this.getHost().scheduleItemsUpdate();
        }
    }

    void setHost(MessageList host) {
        this.host = host;
        if (this.pendingHandle != null) {
            this.attachPendingRegistration(this.pendingHandle);
            this.pendingHandle = null;
        }
    }

    @JsonIgnore
    MessageList getHost() {
        return this.host;
    }
}

