/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.richtexteditor;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.component.richtexteditor.GeneratedVaadinRichTextEditor;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

@Tag(value="vaadin-rich-text-editor")
@HtmlImport(value="frontend://bower_components/vaadin-rich-text-editor/src/vaadin-rich-text-editor.html")
public class RichTextEditor
extends GeneratedVaadinRichTextEditor<RichTextEditor, String>
implements HasSize,
HasValueChangeMode,
InputNotifier,
KeyNotifier,
CompositionNotifier {
    private ValueChangeMode currentMode;
    private RichTextEditorI18n i18n;
    private AsHtml asHtml;

    public RichTextEditorI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(RichTextEditorI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (i18n == this.i18n) {
                JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
                for (String key : i18nObject.keys()) {
                    ui.getPage().executeJavaScript("$0.set('i18n." + key + "', $1)", new Serializable[]{this.getElement(), i18nObject.get(key)});
                }
            }
        });
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public RichTextEditor() {
        super("", "", false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
    }

    public RichTextEditor(String initialValue) {
        this();
        this.setValue(initialValue);
    }

    public RichTextEditor(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<RichTextEditor, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public RichTextEditor(String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<RichTextEditor, String>> listener) {
        this();
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
    }

    public void setValue(String value) {
        super.setValue((Object)value);
    }

    private PendingJavaScriptResult setHtmlValueAsynchronously(String htmlValueString) {
        if (htmlValueString != null) {
            htmlValueString = this.sanitize(htmlValueString);
        }
        return this.getElement().callJsFunction("dangerouslySetHtmlValue", new Serializable[]{htmlValueString});
    }

    @ClientCallable
    private void updateValue(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public String getHtmlValue() {
        String htmlValueString = this.getHtmlValueString();
        if (htmlValueString == null) {
            return null;
        }
        return this.sanitize(htmlValueString);
    }

    String sanitize(String html) {
        return Jsoup.clean((String)html, (Whitelist)Whitelist.basic().addTags(new String[]{"img", "h1", "h2", "h3", "s"}).addAttributes("img", new String[]{"align", "alt", "height", "src", "title", "width"}).addAttributes(":all", new String[]{"style"}).addProtocols("img", "src", new String[]{"data"}));
    }

    public HasValue<HasValue.ValueChangeEvent<String>, String> asHtml() {
        if (this.asHtml == null) {
            this.asHtml = new AsHtml(this);
        }
        return this.asHtml;
    }

    private class AsHtml
    implements HasValue<HasValue.ValueChangeEvent<String>, String> {
        private String oldValue;
        private String value;
        private RichTextEditor rte;

        AsHtml(RichTextEditor rte) {
            this.rte = rte;
            this.value = RichTextEditor.this.getHtmlValue();
            rte.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (event.isFromClient()) {
                    this.setValue(RichTextEditor.this.getHtmlValue(), false);
                }
            });
        }

        public void setValue(String value) {
            this.oldValue = this.getValue();
            this.value = value;
            RichTextEditor.this.setHtmlValueAsynchronously(value).then((SerializableConsumer & Serializable)result -> {
                if (this.oldValue != null && !this.oldValue.equals(value)) {
                    RichTextEditor.this.fireEvent(this.createValueChange(this.oldValue, false));
                }
            });
        }

        private void setValue(String value, boolean fireEvent) {
            if (fireEvent) {
                this.setValue(value);
            } else {
                this.oldValue = this.getValue();
                this.value = value;
            }
        }

        private AbstractField.ComponentValueChangeEvent<RichTextEditor, String> createValueChange(String oldValue, boolean fromClient) {
            return new AbstractField.ComponentValueChangeEvent((Component)this.rte, (HasValue)this, (Object)oldValue, fromClient);
        }

        public String getValue() {
            return this.value;
        }

        public Registration addValueChangeListener(HasValue.ValueChangeListener listener) {
            return this.rte.addValueChangeListener((HasValue.ValueChangeListener & Serializable)originalEvent -> {
                HasValue.ValueChangeEvent<String> event = new HasValue.ValueChangeEvent<String>(){

                    public HasValue<HasValue.ValueChangeEvent<String>, String> getHasValue() {
                        return AsHtml.this;
                    }

                    public boolean isFromClient() {
                        return originalEvent.isFromClient();
                    }

                    public String getOldValue() {
                        return AsHtml.this.oldValue;
                    }

                    public String getValue() {
                        return AsHtml.this.getValue();
                    }
                };
                listener.valueChanged((HasValue.ValueChangeEvent)event);
            });
        }

        public void setReadOnly(boolean readOnly) {
            this.rte.setReadOnly(readOnly);
        }

        public boolean isReadOnly() {
            return this.rte.isReadOnly();
        }

        public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
            this.rte.setRequiredIndicatorVisible(requiredIndicatorVisible);
        }

        public boolean isRequiredIndicatorVisible() {
            return this.rte.isRequiredIndicatorVisible();
        }
    }

    public static class RichTextEditorI18n
    implements Serializable {
        private String undo;
        private String redo;
        private String bold;
        private String italic;
        private String underline;
        private String strike;
        private String h1;
        private String h2;
        private String h3;
        private String subscript;
        private String superscript;
        private String listOrdered;
        private String listBullet;
        private String alignLeft;
        private String alignCenter;
        private String alignRight;
        private String image;
        private String link;
        private String blockquote;
        private String codeBlock;
        private String clean;

        public String getUndo() {
            return this.undo;
        }

        public RichTextEditorI18n setUndo(String undo) {
            this.undo = undo;
            return this;
        }

        public String getRedo() {
            return this.redo;
        }

        public RichTextEditorI18n setRedo(String redo) {
            this.redo = redo;
            return this;
        }

        public String getBold() {
            return this.bold;
        }

        public RichTextEditorI18n setBold(String bold) {
            this.bold = bold;
            return this;
        }

        public String getItalic() {
            return this.italic;
        }

        public RichTextEditorI18n setItalic(String italic) {
            this.italic = italic;
            return this;
        }

        public String getUnderline() {
            return this.underline;
        }

        public RichTextEditorI18n setUnderline(String underline) {
            this.underline = underline;
            return this;
        }

        public String getStrike() {
            return this.strike;
        }

        public RichTextEditorI18n setStrike(String strike) {
            this.strike = strike;
            return this;
        }

        public String getH1() {
            return this.h1;
        }

        public RichTextEditorI18n setH1(String h1) {
            this.h1 = h1;
            return this;
        }

        public String getH2() {
            return this.h2;
        }

        public RichTextEditorI18n setH2(String h2) {
            this.h2 = h2;
            return this;
        }

        public String getH3() {
            return this.h3;
        }

        public RichTextEditorI18n setH3(String h3) {
            this.h3 = h3;
            return this;
        }

        public String getSubscript() {
            return this.subscript;
        }

        public RichTextEditorI18n setSubscript(String subscript) {
            this.subscript = subscript;
            return this;
        }

        public String getSuperscript() {
            return this.superscript;
        }

        public RichTextEditorI18n setSuperscript(String superscript) {
            this.superscript = superscript;
            return this;
        }

        public String getListOrdered() {
            return this.listOrdered;
        }

        public RichTextEditorI18n setListOrdered(String listOrdered) {
            this.listOrdered = listOrdered;
            return this;
        }

        public String getListBullet() {
            return this.listBullet;
        }

        public RichTextEditorI18n setListBullet(String listBullet) {
            this.listBullet = listBullet;
            return this;
        }

        public String getAlignLeft() {
            return this.alignLeft;
        }

        public RichTextEditorI18n setAlignLeft(String alignLeft) {
            this.alignLeft = alignLeft;
            return this;
        }

        public String getAlignCenter() {
            return this.alignCenter;
        }

        public RichTextEditorI18n setAlignCenter(String alignCenter) {
            this.alignCenter = alignCenter;
            return this;
        }

        public String getAlignRight() {
            return this.alignRight;
        }

        public RichTextEditorI18n setAlignRight(String alignRight) {
            this.alignRight = alignRight;
            return this;
        }

        public String getImage() {
            return this.image;
        }

        public RichTextEditorI18n setImage(String image) {
            this.image = image;
            return this;
        }

        public String getLink() {
            return this.link;
        }

        public RichTextEditorI18n setLink(String link) {
            this.link = link;
            return this;
        }

        public String getBlockquote() {
            return this.blockquote;
        }

        public RichTextEditorI18n setBlockquote(String blockquote) {
            this.blockquote = blockquote;
            return this;
        }

        public String getCodeBlock() {
            return this.codeBlock;
        }

        public RichTextEditorI18n setCodeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
            return this;
        }

        public String getClean() {
            return this.clean;
        }

        public RichTextEditorI18n setClean(String clean) {
            this.clean = clean;
            return this;
        }

        public String toString() {
            return "[" + this.undo + ", " + this.redo + ", " + this.bold + ", " + this.italic + ", " + this.underline + ", " + this.strike + ", " + this.h1 + ", " + this.h2 + ", " + this.h3 + ", " + this.subscript + ", " + this.superscript + ", " + this.listOrdered + ", " + this.listBullet + ", " + this.alignLeft + ", " + this.alignCenter + ", " + this.alignRight + ", " + this.image + ", " + this.link + ", " + this.blockquote + ", " + this.codeBlock + ", " + this.clean + "]";
        }
    }
}

