/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.select.data;

import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.data.provider.AbstractDataView;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;

public class SelectDataView<T>
extends AbstractDataView<T> {
    private SerializableConsumer<IdentifierProvider<T>> identifierChangedCallback;

    public SelectDataView(SerializableSupplier<DataProvider<T, ?>> dataProviderSupplier, Select<T> select) {
        super(dataProviderSupplier, select);
    }

    public SelectDataView(SerializableSupplier<DataProvider<T, ?>> dataProviderSupplier, Select<T> select, SerializableConsumer<IdentifierProvider<T>> identifierChangedCallback) {
        super(dataProviderSupplier, select);
        this.identifierChangedCallback = identifierChangedCallback;
    }

    public T getItem(int index) {
        int dataSize = ((DataProvider)this.dataProviderSupplier.get()).size(new Query());
        if (dataSize == 0) {
            throw new IndexOutOfBoundsException(String.format("Requested index %d on empty data.", index));
        }
        if (index < 0 || index >= dataSize) {
            throw new IndexOutOfBoundsException(String.format("Given index %d is outside of the accepted range '0 - %d'", index, dataSize - 1));
        }
        return this.getItems().skip(index).findFirst().orElse(null);
    }

    protected Class<?> getSupportedDataProviderType() {
        return DataProvider.class;
    }

    public void setIdentifierProvider(IdentifierProvider<T> identifierProvider) {
        super.setIdentifierProvider(identifierProvider);
        if (this.identifierChangedCallback != null) {
            this.identifierChangedCallback.accept(identifierProvider);
        }
    }
}

