/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sidenav;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.sidenav.SideNavItem;
import com.vaadin.flow.dom.Element;
import java.util.List;
import java.util.Optional;

abstract class SideNavItemContainer
extends Component {
    SideNavItemContainer() {
    }

    protected void setupSideNavItem(SideNavItem item) {
    }

    public void addItem(SideNavItem ... items) {
        assert (items != null);
        for (SideNavItem item : items) {
            this.setupSideNavItem(item);
            this.getElement().appendChild(new Element[]{item.getElement()});
        }
    }

    public void addItemAsFirst(SideNavItem item) {
        this.addItemAtIndex(0, item);
    }

    public void addItemAtIndex(int index, SideNavItem item) {
        assert (item != null);
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a SideNavItem with a negative index");
        }
        List<SideNavItem> items = this.getItems();
        if (index > items.size()) {
            throw new IllegalArgumentException(String.format("Cannot insert item with index %d when there are %d items", index, items.size()));
        }
        if (index == items.size()) {
            this.addItem(item);
        } else {
            this.setupSideNavItem(item);
            int insertPosition = this.getElement().indexOfChild(items.get(index).getElement());
            this.getElement().insertChild(insertPosition, new Element[]{item.getElement()});
        }
    }

    public List<SideNavItem> getItems() {
        return this.getElement().getChildren().map(Element::getComponent).flatMap(Optional::stream).filter(component -> component instanceof SideNavItem).map(component -> (SideNavItem)((Object)component)).toList();
    }

    public void remove(SideNavItem ... items) {
        for (SideNavItem item : items) {
            Optional parent = item.getParent();
            if (!parent.isPresent() || parent.get() != this) continue;
            this.getElement().removeChild(new Element[]{item.getElement()});
        }
    }

    public void removeAll() {
        List<Element> items = this.getItems().stream().map(Component::getElement).toList();
        this.getElement().removeChild(items);
    }
}

