/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sidenav;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasSuffix;
import com.vaadin.flow.component.sidenav.SideNavItemContainer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.internal.ConfigureRoutes;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.server.RouteRegistry;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Tag(value="vaadin-side-nav-item")
@NpmPackage(value="@vaadin/side-nav", version="24.7.11")
@JsModule(value="@vaadin/side-nav/src/vaadin-side-nav-item.js")
public class SideNavItem
extends SideNavItemContainer
implements HasEnabled,
HasPrefix,
HasSuffix {
    private Element labelElement;
    private QueryParameters queryParameters;

    public SideNavItem(String label) {
        this.setLabel(label);
    }

    public SideNavItem(String label, String path) {
        this.setPath(path);
        this.setLabel(label);
    }

    public SideNavItem(String label, Class<? extends Component> view) {
        this.setPath(view);
        this.setLabel(label);
    }

    public <T, C extends Component> SideNavItem(String label, Class<? extends C> view, T parameter) {
        this(label, view, HasUrlParameterFormat.getParameters(parameter));
    }

    public SideNavItem(String label, Class<? extends Component> view, RouteParameters routeParameters) {
        this.setPath(view, routeParameters);
        this.setLabel(label);
    }

    public SideNavItem(String label, String path, Component prefixComponent) {
        this.setPath(path);
        this.setLabel(label);
        this.setPrefixComponent(prefixComponent);
    }

    public SideNavItem(String label, Class<? extends Component> view, Component prefixComponent) {
        this.setPath(view);
        this.setLabel(label);
        this.setPrefixComponent(prefixComponent);
    }

    public SideNavItem(String label, Class<? extends Component> view, RouteParameters routeParameters, Component prefixComponent) {
        this.setPath(view, routeParameters);
        this.setLabel(label);
        this.setPrefixComponent(prefixComponent);
    }

    @Override
    protected void setupSideNavItem(SideNavItem item) {
        item.getElement().setAttribute("slot", "children");
    }

    public String getLabel() {
        return this.labelElement == null ? null : this.labelElement.getText();
    }

    public void setLabel(String label) {
        if (label == null) {
            this.removeLabelElement();
        } else {
            if (this.labelElement == null) {
                this.labelElement = this.createAndAppendLabelElement();
            }
            this.labelElement.setText(label);
        }
    }

    private Element createAndAppendLabelElement() {
        Element element = Element.createText((String)"");
        this.getElement().appendChild(new Element[]{element});
        return element;
    }

    private void removeLabelElement() {
        if (this.labelElement != null) {
            this.getElement().removeChild(new Element[]{this.labelElement});
            this.labelElement = null;
        }
    }

    public void setPath(String path) {
        if (path == null) {
            this.getElement().removeAttribute("path");
        } else {
            this.getElement().setAttribute("path", this.sanitizePath(this.updateQueryParameters(path)));
        }
    }

    public void setPath(Class<? extends Component> view) {
        this.setPath(view, RouteParameters.empty());
    }

    public <T, C extends Component> void setPath(Class<? extends C> view, T parameter) {
        this.setPath(view, HasUrlParameterFormat.getParameters(parameter));
    }

    public void setPath(Class<? extends Component> view, RouteParameters routeParameters) {
        if (view == null) {
            this.setPath((String)null);
            this.setPathAliases(Collections.emptySet());
        } else {
            RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)ComponentUtil.getRouter((HasElement)this).getRegistry());
            this.setPath(routeConfiguration.getUrl(view, routeParameters));
            this.setPathAliases(this.getPathAliasesFromView(view, routeParameters));
        }
    }

    public String getPath() {
        return this.getElement().getAttribute("path");
    }

    public void setQueryParameters(QueryParameters queryParameters) {
        this.queryParameters = queryParameters;
        this.setPath(this.getPath());
    }

    public Set<String> getPathAliases() {
        JsonArray pathAliases = (JsonArray)this.getElement().getPropertyRaw("pathAliases");
        if (pathAliases == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(JsonSerializer.toObjects(String.class, (JsonArray)pathAliases));
    }

    public void setPathAliases(Set<String> pathAliases) {
        if (pathAliases == null || pathAliases.isEmpty()) {
            this.getElement().removeProperty("pathAliases");
        } else {
            JsonArray aliasesAsJson = JsonSerializer.toJson((Collection)pathAliases.stream().map(alias -> Objects.requireNonNull(alias, "Alias to set cannot be null")).map(this::updateQueryParameters).map(this::sanitizePath).collect(Collectors.toSet()));
            this.getElement().setPropertyJson("pathAliases", (JsonValue)aliasesAsJson);
        }
    }

    public String getTarget() {
        return this.getElement().getProperty("target");
    }

    public void setTarget(String target) {
        if (target == null) {
            this.getElement().removeProperty("target");
        } else {
            this.getElement().setProperty("target", target);
        }
    }

    public boolean isMatchNested() {
        return this.getElement().getProperty("matchNested", false);
    }

    public void setMatchNested(boolean value) {
        this.getElement().setProperty("matchNested", value);
    }

    public boolean isRouterIgnore() {
        return this.getElement().getProperty("routerIgnore", false);
    }

    public void setRouterIgnore(boolean ignore) {
        this.getElement().setProperty("routerIgnore", ignore);
    }

    public void setOpenInNewBrowserTab(boolean openInNewBrowserTab) {
        this.setTarget(openInNewBrowserTab ? "_blank" : null);
    }

    public boolean isOpenInNewBrowserTab() {
        return "_blank".equals(this.getTarget());
    }

    private Set<String> getPathAliasesFromView(Class<? extends Component> view, RouteParameters routeParameters) {
        RouteAlias[] routeAliases = (RouteAlias[])view.getAnnotationsByType(RouteAlias.class);
        return Arrays.stream(routeAliases).map(RouteAlias::value).map(alias -> this.updateAliasWithRouteParameters((String)alias, routeParameters)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private String updateAliasWithRouteParameters(String alias, RouteParameters routeParameters) {
        if (!alias.contains(":")) {
            return alias;
        }
        ConfigureRoutes configuredAliases = new ConfigureRoutes();
        configuredAliases.setRoute(alias, ((Object)((Object)this)).getClass());
        return configuredAliases.getTargetUrl(((Object)((Object)this)).getClass(), this.getRouteParametersForAlias(alias, routeParameters));
    }

    private RouteParameters getRouteParametersForAlias(String alias, RouteParameters routeParameters) {
        Map parametersMapForAlias = routeParameters.getParameterNames().stream().filter(paramName -> alias.contains(":" + paramName)).collect(Collectors.toMap(Function.identity(), paramName -> (String)routeParameters.get(paramName).get()));
        return new RouteParameters(parametersMapForAlias);
    }

    private String updateQueryParameters(String path) {
        int startOfQuery = ((String)path).indexOf(63);
        if (startOfQuery != -1) {
            path = ((String)path).substring(0, startOfQuery);
        }
        if (this.queryParameters != null) {
            path = (String)path + "?" + this.queryParameters.getQueryString();
        }
        return path;
    }

    private String sanitizePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return UrlUtil.encodeURI((String)path);
    }

    public void setExpanded(boolean expanded) {
        this.getElement().setProperty("expanded", expanded);
    }

    @Synchronize(property="expanded", value={"expanded-changed"})
    public boolean isExpanded() {
        return this.getElement().getProperty("expanded", false);
    }
}

