/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.spring.RootMappedCondition;
import com.vaadin.flow.spring.SpringServlet;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import com.vaadin.flow.spring.VaadinServletConfiguration;
import com.vaadin.flow.spring.VaadinServletContextInitializer;
import com.vaadin.flow.spring.VaadinWebsocketEndpointExporter;
import java.util.HashMap;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
@ConditionalOnClass(value={ServletContextInitializer.class})
@EnableConfigurationProperties(value={VaadinConfigurationProperties.class})
@Import(value={VaadinServletConfiguration.class})
public class SpringBootAutoConfiguration {
    @Autowired
    private WebApplicationContext context;
    @Autowired
    private VaadinConfigurationProperties configurationProperties;

    @Bean
    public ServletContextInitializer contextInitializer() {
        return new VaadinServletContextInitializer((ApplicationContext)this.context);
    }

    @Bean
    public ServletRegistrationBean<SpringServlet> servletRegistrationBean() {
        String mapping = this.configurationProperties.getUrlMapping();
        HashMap initParameters = new HashMap();
        boolean rootMapping = RootMappedCondition.isRootMapping(mapping);
        if (rootMapping) {
            mapping = "/vaadinServlet/*";
        }
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new SpringServlet((ApplicationContext)this.context, rootMapping), new String[]{mapping});
        registration.setInitParameters(initParameters);
        registration.setAsyncSupported(this.configurationProperties.isAsyncSupported());
        registration.setName(ClassUtils.getShortNameAsProperty(SpringServlet.class));
        return registration;
    }

    @Bean
    public ServerEndpointExporter websocketEndpointDeployer() {
        return new VaadinWebsocketEndpointExporter();
    }
}

