/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.server.SessionDestroyEvent;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SpringVaadinSession
extends VaadinSession {
    private final List<SessionDestroyListener> destroyListeners = new CopyOnWriteArrayList<SessionDestroyListener>();

    public SpringVaadinSession(VaadinService service) {
        super(service);
    }

    public void fireSessionDestroy() {
        SessionDestroyEvent event = new SessionDestroyEvent(this.getService(), (VaadinSession)this);
        this.destroyListeners.stream().forEach(listener -> listener.sessionDestroy(event));
        this.destroyListeners.clear();
    }

    public void addDestroyListener(SessionDestroyListener listener) {
        this.destroyListeners.add(listener);
    }
}

