/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RetryRule
implements TestRule {
    private int maxAttempts;

    public RetryRule(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Statement apply(Statement base, Description description) {
        if (this.maxAttempts > 1) {
            return this.statement(base, description);
        }
        return base;
    }

    private Statement statement(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable caughtThrowable = null;
                for (int i = 0; i < RetryRule.this.maxAttempts; ++i) {
                    try {
                        base.evaluate();
                        return;
                    }
                    catch (AssumptionViolatedException t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        caughtThrowable = t;
                        continue;
                    }
                }
                String errorMessage = String.format("%s: run failed %s times", description.getDisplayName(), RetryRule.this.maxAttempts);
                throw new RuntimeException(errorMessage, caughtThrowable);
            }
        };
    }
}

