/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload.receivers;

import com.vaadin.flow.component.upload.MultiFileReceiver;
import com.vaadin.flow.component.upload.receivers.FileData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MultiFileMemoryBuffer
implements MultiFileReceiver {
    private Map<String, FileData> files = new HashMap<String, FileData>();

    @Override
    public OutputStream receiveUpload(String fileName, String MIMEType) {
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        this.files.put(fileName, new FileData(fileName, MIMEType, outputBuffer));
        return outputBuffer;
    }

    public Set<String> getFiles() {
        return this.files.keySet();
    }

    public FileData getFileData(String fileName) {
        return this.files.get(fileName);
    }

    public ByteArrayOutputStream getOutputBuffer(String fileName) {
        if (this.files.containsKey(fileName)) {
            return (ByteArrayOutputStream)this.files.get(fileName).getOutputBuffer();
        }
        return new ByteArrayOutputStream();
    }

    public InputStream getInputStream(String filename) {
        if (this.files.containsKey(filename)) {
            return new ByteArrayInputStream(((ByteArrayOutputStream)this.files.get(filename).getOutputBuffer()).toByteArray());
        }
        return new ByteArrayInputStream(new byte[0]);
    }
}

