/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.callback.longpoll;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.vk.api.sdk.client.ApiRequest;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.exceptions.ApiException;
import com.vk.api.sdk.exceptions.ClientException;
import com.vk.api.sdk.exceptions.LongPollServerKeyExpiredException;
import com.vk.api.sdk.exceptions.LongPollServerTsException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LongPollQueryBuilder<T, R>
extends ApiRequest<R> {
    private static final Logger LOG = LogManager.getLogger(LongPollQueryBuilder.class);
    private static final Integer RETRY_ATTEMPTS = 3;
    private static final int INCORRECT_TS_VALUE_ERROR_CODE = 1;
    private static final int TOKEN_EXPIRED_ERROR_CODE = 2;
    private static final String FAILED_CODE = "failed";
    private final Map<String, String> params = new HashMap<String, String>();

    public LongPollQueryBuilder(VkApiClient client, String url, Type type) {
        super(url, client.getTransportClient(), client.getGson(), RETRY_ATTEMPTS, type);
    }

    private static String escape(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected T key(String key) {
        return this.unsafeParam("key", key);
    }

    public T unsafeParam(String key, String value) {
        this.params.put(key, value);
        return this.getThis();
    }

    public T unsafeParam(String key, int value) {
        return this.unsafeParam(key, Integer.toString(value));
    }

    private static String mapToGetString(Map<String, String> params) {
        return params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (entry.getValue() != null ? LongPollQueryBuilder.escape((String)entry.getValue()) : "")).collect(Collectors.joining("&"));
    }

    @Override
    protected String getBody() {
        return LongPollQueryBuilder.mapToGetString(this.build());
    }

    protected abstract T getThis();

    protected abstract Collection<String> essentialKeys();

    public Map<String, String> build() {
        if (!this.params.keySet().containsAll(this.essentialKeys())) {
            throw new IllegalArgumentException("Not all the keys are passed: essential keys are " + this.essentialKeys());
        }
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public R execute() throws ApiException, ClientException {
        String textResponse = this.executeAsString();
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(textResponse));
        JsonObject json = (JsonObject)new JsonParser().parse(jsonReader);
        if (json.has(FAILED_CODE)) {
            JsonPrimitive failedParam = json.getAsJsonPrimitive(FAILED_CODE);
            int code = failedParam.getAsInt();
            switch (code) {
                case 1: {
                    int ts = json.getAsJsonPrimitive("ts").getAsInt();
                    throw new LongPollServerTsException("'ts' value is incorrect, minimal value is 1, maximal value is " + ts);
                }
                case 2: {
                    throw new LongPollServerKeyExpiredException("Try to generate a new key.");
                }
            }
            throw new ClientException("Unknown LongPollServer exception, something went wrong.");
        }
        try {
            return (R)this.getGson().fromJson((JsonElement)json, this.getResponseClass());
        }
        catch (JsonSyntaxException e) {
            LOG.error("Invalid JSON: " + textResponse, (Throwable)e);
            throw new ClientException("Can't parse json response");
        }
    }
}

