/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.streaming.queries;

import com.vk.api.sdk.streaming.clients.VkStreamingApiClient;
import com.vk.api.sdk.streaming.clients.actors.StreamingActor;
import com.vk.api.sdk.streaming.exceptions.StreamingClientException;
import com.vk.api.sdk.streaming.queries.StreamingAbstractQuery;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamingAbstractPostQuery
extends StreamingAbstractQuery {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingAbstractPostQuery.class);
    private static final String CONTENT_TYPE = "application/json";
    private String body;

    public StreamingAbstractPostQuery(VkStreamingApiClient client, StreamingActor actor, String path, Type responseClass) {
        super(client, actor, path, responseClass);
    }

    @Override
    public String executeAsString() throws StreamingClientException {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.body)) {
                return this.getHttpClient().post(this.getUrl(), this.body, CONTENT_TYPE).getContent();
            }
            return this.getHttpClient().post(this.getUrl(), null, CONTENT_TYPE).getContent();
        }
        catch (IOException e) {
            LOG.error("Problems with request: " + this.getUrl(), (Throwable)e);
            throw new StreamingClientException("I/O exception");
        }
    }

    public void setBody(Object object) {
        this.body = this.getGson().toJson(object);
    }
}

