/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.streaming.queries;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.vk.api.sdk.callback.longpoll.LongPollQueryBuilder;
import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.streaming.clients.VkStreamingApiClient;
import com.vk.api.sdk.streaming.clients.actors.StreamingActor;
import com.vk.api.sdk.streaming.exceptions.StreamingApiException;
import com.vk.api.sdk.streaming.exceptions.StreamingClientException;
import com.vk.api.sdk.streaming.objects.responses.StreamingResponse;
import java.lang.reflect.Type;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class StreamingAbstractQuery {
    private static final Logger LOG = LogManager.getLogger(LongPollQueryBuilder.class);
    private TransportClient httpClient;
    private Gson gson;
    private Type responseClass;
    private String url;

    public StreamingAbstractQuery(VkStreamingApiClient client, StreamingActor actor, String path, Type responseClass) {
        this.responseClass = responseClass;
        this.gson = client.getGson();
        this.httpClient = client.getTransportClient();
        this.url = this.buildUrl(actor, path);
    }

    TransportClient getHttpClient() {
        return this.httpClient;
    }

    Gson getGson() {
        return this.gson;
    }

    String getUrl() {
        return this.url;
    }

    private String buildUrl(StreamingActor actor, String path) {
        return "https://" + actor.getEndpoint() + "/" + path + "?key=" + actor.getKey();
    }

    public abstract String executeAsString() throws StreamingClientException;

    public <T extends StreamingResponse> T execute() throws StreamingClientException, StreamingApiException {
        StreamingResponse response;
        String json = this.executeAsString();
        try {
            response = (StreamingResponse)this.gson.fromJson(json, this.responseClass);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Invalid JSON: " + json, (Throwable)e);
            throw new StreamingClientException("Can't parse json response");
        }
        if (response.getError() != null) {
            throw new StreamingApiException(response.getError());
        }
        return (T)response;
    }
}

