/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.adaptor;

import com.vladmihalcea.flexypool.adaptor.PoolAdapter;
import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.connection.ConnectionRequestContext;
import com.vladmihalcea.flexypool.connection.Credentials;
import com.vladmihalcea.flexypool.event.ConnectionAcquireTimeoutEvent;
import com.vladmihalcea.flexypool.event.EventPublisher;
import com.vladmihalcea.flexypool.exception.AcquireTimeoutException;
import com.vladmihalcea.flexypool.metric.Metrics;
import com.vladmihalcea.flexypool.metric.Timer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public abstract class AbstractPoolAdapter<T extends DataSource>
implements PoolAdapter<T> {
    public static final String CONNECTION_ACQUIRE_MILLIS = "connectionAcquireMillis";
    private final ConfigurationProperties<T, Metrics, PoolAdapter<T>> configurationProperties;
    private final T targetDataSource;
    private final Timer connectionAcquireTimer;
    private final EventPublisher eventPublisher;

    public AbstractPoolAdapter(ConfigurationProperties<T, Metrics, PoolAdapter<T>> configurationProperties) {
        this.configurationProperties = configurationProperties;
        this.targetDataSource = configurationProperties.getTargetDataSource();
        this.connectionAcquireTimer = configurationProperties.getMetrics().timer(CONNECTION_ACQUIRE_MILLIS);
        this.eventPublisher = configurationProperties.getEventPublisher();
    }

    @Override
    public T getTargetDataSource() {
        return this.targetDataSource;
    }

    @Override
    public Connection getConnection(ConnectionRequestContext requestContext) throws SQLException {
        long startNanos = System.nanoTime();
        try {
            Credentials credentials = requestContext.getCredentials();
            Connection connection = credentials == null ? this.targetDataSource.getConnection() : this.targetDataSource.getConnection(credentials.getUsername(), credentials.getPassword());
            return connection;
        }
        catch (SQLException e) {
            throw this.translateException(e);
        }
        catch (RuntimeException e) {
            throw this.translateException(e);
        }
        finally {
            long endNanos = System.nanoTime();
            this.connectionAcquireTimer.update(TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos), TimeUnit.MILLISECONDS);
        }
    }

    protected SQLException translateException(Exception e) {
        if (this.isAcquireTimeoutException(e)) {
            this.eventPublisher.publish(new ConnectionAcquireTimeoutEvent(this.configurationProperties.getUniqueName()));
            return new AcquireTimeoutException(e);
        }
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        return new SQLException(e);
    }

    protected abstract boolean isAcquireTimeoutException(Exception var1);
}

