/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.config;

import com.vladmihalcea.flexypool.adaptor.PoolAdapter;
import com.vladmihalcea.flexypool.adaptor.PoolAdapterFactory;
import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.connection.ConnectionDecoratorFactoryResolver;
import com.vladmihalcea.flexypool.connection.ConnectionProxyFactory;
import com.vladmihalcea.flexypool.event.EventListenerResolver;
import com.vladmihalcea.flexypool.event.EventPublisher;
import com.vladmihalcea.flexypool.metric.Metrics;
import com.vladmihalcea.flexypool.metric.MetricsFactory;
import com.vladmihalcea.flexypool.metric.MetricsFactoryResolver;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public final class Configuration<T extends DataSource>
extends ConfigurationProperties<T, Metrics, PoolAdapter<T>> {
    public static final long DEFAULT_METRIC_LOG_REPORTER_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private final T targetDataSource;
    private Metrics metrics;
    private PoolAdapter<T> poolAdapter;
    private ConnectionProxyFactory connectionProxyFactory;

    private Configuration(String uniqueName, T targetDataSource, EventPublisher eventPublisher) {
        super(uniqueName, eventPublisher);
        this.targetDataSource = targetDataSource;
    }

    @Override
    public T getTargetDataSource() {
        return this.targetDataSource;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public PoolAdapter<T> getPoolAdapter() {
        return this.poolAdapter;
    }

    @Override
    public ConnectionProxyFactory getConnectionProxyFactory() {
        return this.connectionProxyFactory;
    }

    /* synthetic */ Configuration(String x0, DataSource x1, EventPublisher x2, 1 x3) {
        this(x0, x1, x2);
    }

    public static class Builder<T extends DataSource> {
        private final String uniqueName;
        private final T targetDataSource;
        private final PoolAdapterFactory<T> poolAdapterFactory;
        private MetricsFactory metricsFactory;
        private ConnectionProxyFactory connectionProxyFactory = ConnectionDecoratorFactoryResolver.INSTANCE.resolve();
        private boolean jmxEnabled = true;
        private boolean jmxAutoStart = false;
        private long metricLogReporterMillis = DEFAULT_METRIC_LOG_REPORTER_MILLIS;
        private EventListenerResolver eventListenerResolver;
        private long connectionAcquireTimeThresholdMillis = Long.MAX_VALUE;
        private long connectionLeaseTimeThresholdMillis = Long.MAX_VALUE;

        public Builder(String uniqueName, T targetDataSource, PoolAdapterFactory<T> poolAdapterFactory) {
            this.uniqueName = uniqueName;
            this.targetDataSource = targetDataSource;
            this.poolAdapterFactory = poolAdapterFactory;
        }

        public Builder<T> setMetricsFactory(MetricsFactory metricsFactory) {
            this.metricsFactory = metricsFactory;
            return this;
        }

        public Builder<T> setConnectionProxyFactory(ConnectionProxyFactory connectionProxyFactory) {
            this.connectionProxyFactory = connectionProxyFactory;
            return this;
        }

        public Builder<T> setJmxEnabled(boolean enableJmx) {
            this.jmxEnabled = enableJmx;
            return this;
        }

        public Builder<T> setJmxAutoStart(boolean jmxAutoStart) {
            this.jmxAutoStart = jmxAutoStart;
            return this;
        }

        public Builder<T> setMetricLogReporterMillis(long metricLogReporterMillis) {
            this.metricLogReporterMillis = metricLogReporterMillis;
            return this;
        }

        public Builder<T> setEventListenerResolver(EventListenerResolver eventListenerResolver) {
            this.eventListenerResolver = eventListenerResolver;
            return this;
        }

        public Builder<T> setConnectionAcquireTimeThresholdMillis(Long connectionAcquireTimeThresholdMillis) {
            if (connectionAcquireTimeThresholdMillis != null) {
                this.connectionAcquireTimeThresholdMillis = connectionAcquireTimeThresholdMillis;
            }
            return this;
        }

        public Builder<T> setConnectionLeaseTimeThresholdMillis(Long connectionLeaseTimeThresholdMillis) {
            if (connectionLeaseTimeThresholdMillis != null) {
                this.connectionLeaseTimeThresholdMillis = connectionLeaseTimeThresholdMillis;
            }
            return this;
        }

        public Configuration<T> build() {
            EventPublisher eventPublisher = EventPublisher.newInstance(this.eventListenerResolver);
            Configuration configuration = new Configuration(this.uniqueName, (DataSource)this.targetDataSource, eventPublisher, null);
            configuration.setJmxEnabled(this.jmxEnabled);
            configuration.setJmxAutoStart(this.jmxAutoStart);
            configuration.setMetricLogReporterMillis(this.metricLogReporterMillis);
            configuration.setConnectionAcquireTimeThresholdMillis(this.connectionAcquireTimeThresholdMillis);
            configuration.setConnectionLeaseTimeThresholdMillis(this.connectionLeaseTimeThresholdMillis);
            if (this.metricsFactory == null) {
                this.metricsFactory = MetricsFactoryResolver.INSTANCE.resolve();
            }
            configuration.metrics = this.metricsFactory.newInstance(configuration);
            configuration.poolAdapter = this.poolAdapterFactory.newInstance(configuration);
            configuration.connectionProxyFactory = this.connectionProxyFactory;
            return configuration;
        }
    }
}

