/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.strategy;

import com.vladmihalcea.flexypool.adaptor.PoolAdapter;
import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.connection.ConnectionRequestContext;
import com.vladmihalcea.flexypool.exception.AcquireTimeoutException;
import com.vladmihalcea.flexypool.metric.Histogram;
import com.vladmihalcea.flexypool.metric.Metrics;
import com.vladmihalcea.flexypool.strategy.AbstractConnectionAcquiringStrategy;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquiringStrategyFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncrementPoolOnTimeoutConnectionAcquiringStrategy<T extends DataSource>
extends AbstractConnectionAcquiringStrategy {
    public static final String MAX_POOL_SIZE_HISTOGRAM = "maxPoolSizeHistogram";
    public static final String OVERFLOW_POOL_SIZE_HISTOGRAM = "overflowPoolSizeHistogram";
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementPoolOnTimeoutConnectionAcquiringStrategy.class);
    private final Lock lock = new ReentrantLock();
    private final int maxOverflowPoolSize;
    private final int timeoutMillis;
    private AtomicLong overflowPoolSize = new AtomicLong();
    private final Histogram maxPoolSizeHistogram;
    private final Histogram overflowPoolSizeHistogram;
    private final PoolAdapter poolAdapter;

    private IncrementPoolOnTimeoutConnectionAcquiringStrategy(ConfigurationProperties<? extends DataSource, Metrics, PoolAdapter> configurationProperties, int maxOverflowPoolSize, int timeoutMillis) {
        super(configurationProperties);
        this.maxOverflowPoolSize = maxOverflowPoolSize;
        this.timeoutMillis = timeoutMillis;
        this.maxPoolSizeHistogram = configurationProperties.getMetrics().histogram(MAX_POOL_SIZE_HISTOGRAM);
        this.overflowPoolSizeHistogram = configurationProperties.getMetrics().histogram(OVERFLOW_POOL_SIZE_HISTOGRAM);
        this.maxPoolSizeHistogram.update(configurationProperties.getPoolAdapter().getMaxPoolSize());
        this.poolAdapter = configurationProperties.getPoolAdapter();
    }

    @Override
    public Connection getConnection(ConnectionRequestContext requestContext) throws SQLException {
        while (true) {
            int expectingMaxSize = this.poolAdapter.getMaxPoolSize();
            try {
                long startNanos = System.nanoTime();
                Connection connection = this.getConnectionFactory().getConnection(requestContext);
                long endNanos = System.nanoTime();
                long connectionAcquireDurationMillis = TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos);
                if (connectionAcquireDurationMillis > (long)this.timeoutMillis) {
                    LOGGER.warn("Connection was acquired in {} millis, timeoutMillis is set to {}", (Object)connectionAcquireDurationMillis, (Object)this.timeoutMillis);
                    int maxPoolSize = this.poolAdapter.getMaxPoolSize();
                    if (maxPoolSize < this.maxOverflowPoolSize) {
                        if (!this.incrementPoolSize(expectingMaxSize)) {
                            LOGGER.warn("Can't acquire connection, pool size has already overflown to its max size.");
                        }
                    } else {
                        LOGGER.info("Pool size has already overflown to its max size of {}", (Object)maxPoolSize);
                    }
                }
                return connection;
            }
            catch (AcquireTimeoutException e) {
                if (this.incrementPoolSize(expectingMaxSize)) continue;
                LOGGER.warn("Can't acquire connection due to adaptor timeout, pool size has already overflown to its max size.");
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean incrementPoolSize(int expectingMaxSize) {
        long currentOverflowPoolSize;
        Integer maxSize = null;
        try {
            boolean incrementMaxPoolSize;
            this.lock.lockInterruptibly();
            int currentMaxSize = this.poolAdapter.getMaxPoolSize();
            boolean bl = incrementMaxPoolSize = currentMaxSize < this.maxOverflowPoolSize;
            if (currentMaxSize > expectingMaxSize) {
                LOGGER.info("Pool size changed by other thread, expected {} and actual value {}", (Object)expectingMaxSize, (Object)currentMaxSize);
                boolean bl2 = incrementMaxPoolSize;
                return bl2;
            }
            if (!incrementMaxPoolSize) {
                boolean bl3 = false;
                return bl3;
            }
            currentOverflowPoolSize = this.overflowPoolSize.incrementAndGet();
            this.poolAdapter.setMaxPoolSize(++currentMaxSize);
            maxSize = currentMaxSize;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
        LOGGER.info("Pool size changed from previous value {} to {}", (Object)expectingMaxSize, (Object)maxSize);
        this.maxPoolSizeHistogram.update(maxSize.intValue());
        this.overflowPoolSizeHistogram.update(currentOverflowPoolSize);
        return true;
    }

    public String toString() {
        return "IncrementPoolOnTimeoutConnectionAcquiringStrategy{maxOverflowPoolSize=" + this.maxOverflowPoolSize + '}';
    }

    public static class Factory<T extends DataSource>
    implements ConnectionAcquiringStrategyFactory<IncrementPoolOnTimeoutConnectionAcquiringStrategy, T> {
        private final int maxOverflowPoolSize;
        private final int timeoutMillis;

        public Factory(int maxOverflowPoolSize, int timeoutMillis) {
            this.maxOverflowPoolSize = maxOverflowPoolSize;
            this.timeoutMillis = timeoutMillis;
        }

        public Factory(int maxOverflowPoolSize) {
            this(maxOverflowPoolSize, Integer.MAX_VALUE);
        }

        @Override
        public IncrementPoolOnTimeoutConnectionAcquiringStrategy newInstance(ConfigurationProperties<T, Metrics, PoolAdapter<T>> configurationProperties) {
            return new IncrementPoolOnTimeoutConnectionAcquiringStrategy(configurationProperties, this.maxOverflowPoolSize, this.timeoutMillis);
        }
    }
}

