/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItem;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItemPlacement;
import com.vladsch.flexmark.ext.gfm.tasklist.internal.FormatOptions;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.internal.CoreNodeFormatter;
import com.vladsch.flexmark.formatter.internal.MarkdownWriter;
import com.vladsch.flexmark.formatter.internal.NodeFormatter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.formatter.internal.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.internal.NodeFormattingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TaskListNodeFormatter
implements NodeFormatter {
    private final FormatOptions myOptions;

    public TaskListNodeFormatter(DataHolder options) {
        this.myOptions = new FormatOptions(options);
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(TaskListItem.class, (CustomNodeFormatter)new CustomNodeFormatter<TaskListItem>(){

            public void render(TaskListItem node, NodeFormatterContext context, MarkdownWriter markdown) {
                TaskListNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(BulletList.class, (CustomNodeFormatter)new CustomNodeFormatter<BulletList>(){

            public void render(BulletList node, NodeFormatterContext context, MarkdownWriter markdown) {
                TaskListNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(OrderedList.class, (CustomNodeFormatter)new CustomNodeFormatter<OrderedList>(){

            public void render(OrderedList node, NodeFormatterContext context, MarkdownWriter markdown) {
                TaskListNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    private void render(TaskListItem node, NodeFormatterContext context, MarkdownWriter markdown) {
        BasedSequence markerSuffix = node.getMarkerSuffix();
        switch (this.myOptions.taskListItemCase) {
            case AS_IS: {
                break;
            }
            case LOWERCASE: {
                markerSuffix = markerSuffix.toLowerCase();
                break;
            }
            case UPPERCASE: {
                markerSuffix = markerSuffix.toUpperCase();
                break;
            }
            default: {
                throw new IllegalStateException("Missing case for TaskListItemCase " + this.myOptions.taskListItemCase.name());
            }
        }
        if (node.isItemDoneMarker()) {
            switch (this.myOptions.taskListItemPlacement) {
                case AS_IS: 
                case INCOMPLETE_FIRST: 
                case INCOMPLETE_NESTED_FIRST: {
                    break;
                }
                case COMPLETE_TO_NON_TASK: 
                case COMPLETE_NESTED_TO_NON_TASK: {
                    markerSuffix = BasedSequence.NULL;
                    break;
                }
                default: {
                    throw new IllegalStateException("Missing case for ListItemPlacement " + this.myOptions.taskListItemPlacement.name());
                }
            }
        }
        CoreNodeFormatter.renderListItem((ListItem)node, (NodeFormatterContext)context, (MarkdownWriter)markdown, (CharSequence)(markerSuffix.isEmpty() ? markerSuffix : markerSuffix.append(new CharSequence[]{" "})));
    }

    private void render(BulletList node, NodeFormatterContext context, MarkdownWriter markdown) {
        TaskListNodeFormatter.renderList((ListBlock)node, context, markdown, this.myOptions);
    }

    private void render(OrderedList node, NodeFormatterContext context, MarkdownWriter markdown) {
        TaskListNodeFormatter.renderList((ListBlock)node, context, markdown, this.myOptions);
    }

    public static boolean hasIncompleteDescendants(Node node) {
        for (Node item = node.getFirstChild(); item != null; item = item.getNext()) {
            if (item instanceof TaskListItem && !((TaskListItem)item).isItemDoneMarker()) {
                return true;
            }
            if (!(item instanceof Block) || item instanceof Paragraph || !TaskListNodeFormatter.hasIncompleteDescendants(item)) continue;
            return true;
        }
        return false;
    }

    public static void renderList(ListBlock node, NodeFormatterContext context, MarkdownWriter markdown, FormatOptions formatOptions) {
        ArrayList itemList = new ArrayList();
        TaskListItemPlacement taskListItemPlacement = formatOptions.taskListItemPlacement;
        if (taskListItemPlacement != TaskListItemPlacement.AS_IS) {
            ArrayList<Node> incompleteTasks = new ArrayList<Node>();
            ArrayList<Node> completeItems = new ArrayList<Node>();
            boolean incompleteDescendants = taskListItemPlacement == TaskListItemPlacement.INCOMPLETE_NESTED_FIRST || taskListItemPlacement == TaskListItemPlacement.COMPLETE_NESTED_TO_NON_TASK;
            for (Node item = node.getFirstChild(); item != null; item = item.getNext()) {
                if (item instanceof TaskListItem) {
                    TaskListItem taskItem = (TaskListItem)item;
                    if (!taskItem.isItemDoneMarker() || incompleteDescendants && TaskListNodeFormatter.hasIncompleteDescendants(item)) {
                        incompleteTasks.add(item);
                        continue;
                    }
                    completeItems.add(item);
                    continue;
                }
                if (incompleteDescendants && TaskListNodeFormatter.hasIncompleteDescendants(item)) {
                    incompleteTasks.add(item);
                    continue;
                }
                completeItems.add(item);
            }
            itemList.addAll(incompleteTasks);
            itemList.addAll(completeItems);
        } else {
            for (Node item = node.getFirstChild(); item != null; item = item.getNext()) {
                itemList.add(item);
            }
        }
        CoreNodeFormatter.renderList((ListBlock)node, (NodeFormatterContext)context, (MarkdownWriter)markdown, itemList);
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new TaskListNodeFormatter(options);
        }
    }
}

