/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables;

import com.vladsch.flexmark.ast.DelimitedNode;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.WhiteSpace;
import com.vladsch.flexmark.ast.util.TextNodeConverter;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class TableCell
extends Node
implements DelimitedNode {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    private boolean header;
    private Alignment alignment;
    private int span = 1;

    public void trimWhiteSpace() {
        Node next;
        Node firstChild;
        Node child = firstChild = this.getFirstChild();
        while (child instanceof WhiteSpace) {
            next = child.getNext();
            child.unlink();
            child = next;
        }
        child = this.getLastChild();
        while (child instanceof WhiteSpace) {
            next = child.getPrevious();
            child.unlink();
            child = next;
        }
        if (this.getFirstChild() == null && firstChild != null) {
            Text text = new Text((BasedSequence)firstChild.getChars().subSequence(0, 1));
            this.appendChild((Node)text);
        }
    }

    public void mergeWhiteSpace() {
        Text text;
        boolean hadWhitespace = false;
        Node child = this.getFirstChild();
        while (child instanceof WhiteSpace) {
            Node next = child.getNext();
            text = new Text(child.getChars());
            child.insertBefore((Node)text);
            child.unlink();
            child = next;
            hadWhitespace = true;
        }
        child = this.getLastChild();
        while (child instanceof WhiteSpace) {
            Node previous = child.getPrevious();
            text = new Text(child.getChars());
            child.insertBefore((Node)text);
            child.unlink();
            child = previous;
            hadWhitespace = true;
        }
        if (hadWhitespace) {
            TextNodeConverter.mergeTextNodes((Node)this);
        }
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getText() {
        return this.text;
    }

    public void setText(BasedSequence text) {
        this.text = text;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker};
    }

    public void getAstExtra(StringBuilder out) {
        if (this.alignment != null) {
            out.append(" ").append((Object)this.alignment);
        }
        if (this.header) {
            out.append(" header");
        }
        if (this.span > 1) {
            out.append(" span=" + this.span);
        }
        TableCell.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.openingMarker, (BasedSequence)this.text, (BasedSequence)this.closingMarker, (String)"text");
    }

    public TableCell() {
    }

    public TableCell(BasedSequence chars) {
        super(chars);
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;


        public CellAlignment cellAlignment() {
            switch (this) {
                case CENTER: {
                    return CellAlignment.CENTER;
                }
                case LEFT: {
                    return CellAlignment.LEFT;
                }
                case RIGHT: {
                    return CellAlignment.RIGHT;
                }
            }
            return CellAlignment.NONE;
        }
    }
}

