/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import java.io.IOException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;

class MarkerResolver
implements EventResolver {
    private static final TemplateResolver<LogEvent> NAME_RESOLVER = (logEvent, jsonGenerator) -> {
        Marker marker = logEvent.getMarker();
        if (marker == null) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeString(marker.getName());
        }
    };
    private final TemplateResolver<LogEvent> internalResolver;

    MarkerResolver(String key) {
        this.internalResolver = this.createInternalResolver(key);
    }

    private TemplateResolver<LogEvent> createInternalResolver(String key) {
        switch (key) {
            case "name": {
                return NAME_RESOLVER;
            }
        }
        throw new IllegalArgumentException("unknown key: " + key);
    }

    static String getName() {
        return "marker";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
        this.internalResolver.resolve(logEvent, jsonGenerator);
    }
}

