/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import com.vlkan.log4j2.logstash.layout.util.JsonGenerators;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.TriConsumer;

class MessageResolver
implements EventResolver {
    private static final String NAME = "message";
    private static final String[] FORMATS = new String[]{"JSON"};
    private final EventResolverContext context;
    private final String key;
    private static TriConsumer<String, Object, JsonGenerator> MAP_MESSAGE_ENTRY_WRITER = (key, value, jsonGenerator) -> {
        try {
            jsonGenerator.writeFieldName(key);
            JsonGenerators.writeObject(jsonGenerator, value);
        }
        catch (IOException error) {
            throw new RuntimeException("MapMessage entry serialization failure", error);
        }
    };

    MessageResolver(EventResolverContext context, String key) {
        this.context = context;
        this.key = key;
    }

    static String getName() {
        return NAME;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
        Message message = logEvent.getMessage();
        if (FORMATS[0].equalsIgnoreCase(this.key)) {
            this.resolveJson(message, jsonGenerator);
        } else {
            this.resolveText(message, jsonGenerator);
        }
    }

    private void resolveText(Message message, JsonGenerator jsonGenerator) throws IOException {
        String formattedMessage = this.resolveText(message);
        if (formattedMessage == null) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeString(formattedMessage);
        }
    }

    private String resolveText(Message message) {
        String formattedMessage = message.getFormattedMessage();
        boolean messageExcluded = this.context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)formattedMessage);
        return messageExcluded ? null : formattedMessage;
    }

    private void resolveJson(Message message, JsonGenerator jsonGenerator) throws IOException {
        if (this.writeSimpleMessage(jsonGenerator, message)) {
            return;
        }
        if (this.writeMultiformatMessage(jsonGenerator, message)) {
            return;
        }
        if (this.writeObjectMessage(jsonGenerator, message)) {
            return;
        }
        this.writeObject(message, jsonGenerator);
    }

    private boolean writeSimpleMessage(JsonGenerator jsonGenerator, Message message) throws IOException {
        boolean messageExcluded;
        if (!(message instanceof SimpleMessage)) {
            return false;
        }
        SimpleMessage simpleMessage = (SimpleMessage)message;
        String formattedMessage = simpleMessage.getFormattedMessage();
        boolean bl = messageExcluded = this.context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)formattedMessage);
        if (messageExcluded) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeString(formattedMessage);
        }
        return true;
    }

    private boolean writeMultiformatMessage(JsonGenerator jsonGenerator, Message message) throws IOException {
        String[] formats;
        if (!(message instanceof MultiformatMessage)) {
            return false;
        }
        MultiformatMessage multiformatMessage = (MultiformatMessage)message;
        if (this.context.isMapMessageFormatterIgnored() && message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            MessageResolver.writeMapMessage(jsonGenerator, mapMessage);
            return true;
        }
        boolean jsonSupported = false;
        for (String format : formats = multiformatMessage.getFormats()) {
            if (!FORMATS[0].equalsIgnoreCase(format)) continue;
            jsonSupported = true;
            break;
        }
        if (!jsonSupported) {
            this.writeObject(message, jsonGenerator);
            return true;
        }
        String messageJson = multiformatMessage.getFormattedMessage(FORMATS);
        JsonNode jsonNode = MessageResolver.readMessageJson(this.context, messageJson);
        boolean nodeExcluded = this.isNodeExcluded(jsonNode);
        if (nodeExcluded) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeTree((TreeNode)jsonNode);
        }
        return true;
    }

    private static void writeMapMessage(JsonGenerator jsonGenerator, MapMessage mapMessage) throws IOException {
        jsonGenerator.writeStartObject();
        mapMessage.forEach(MAP_MESSAGE_ENTRY_WRITER, (Object)jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private static JsonNode readMessageJson(EventResolverContext context, String messageJson) {
        try {
            return context.getObjectMapper().readTree(messageJson);
        }
        catch (IOException error) {
            throw new RuntimeException("JSON message read failure", error);
        }
    }

    private void writeObject(Message message, JsonGenerator jsonGenerator) throws IOException {
        String formattedMessage = this.resolveText(message);
        if (formattedMessage == null) {
            jsonGenerator.writeNull();
            return;
        }
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField(NAME, (Object)formattedMessage);
        jsonGenerator.writeEndObject();
    }

    private boolean isNodeExcluded(JsonNode jsonNode) {
        if (!this.context.isEmptyPropertyExclusionEnabled()) {
            return false;
        }
        if (jsonNode.isNull()) {
            return true;
        }
        if (jsonNode.isTextual() && StringUtils.isEmpty((CharSequence)jsonNode.asText())) {
            return true;
        }
        return jsonNode.isContainerNode() && jsonNode.size() == 0;
    }

    private boolean writeObjectMessage(JsonGenerator jsonGenerator, Message message) throws IOException {
        if (!(message instanceof ObjectMessage)) {
            return false;
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        Object object = objectMessage.getParameter();
        JsonGenerators.writeObject(jsonGenerator, object);
        return true;
    }
}

