/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageApiResponseException;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageMethodFailedException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.ApiKeyQueryParamsAuthMethod;
import com.vonage.client.auth.AuthMethod;
import com.vonage.client.auth.HeaderAuthMethod;
import com.vonage.client.auth.QueryParamsAuthMethod;
import com.vonage.client.auth.RequestQueryParams;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public abstract class AbstractMethod<REQ, RES>
implements RestEndpoint<REQ, RES> {
    private static final Logger LOGGER = Logger.getLogger(AbstractMethod.class.getName());
    private static final Level LOG_LEVEL = Level.FINE;
    private final HttpWrapper httpWrapper;

    private static boolean shouldLog() {
        return LOGGER.isLoggable(LOG_LEVEL);
    }

    protected AbstractMethod(HttpWrapper httpWrapper) {
        this.httpWrapper = httpWrapper;
    }

    public HttpWrapper getHttpWrapper() {
        return this.httpWrapper;
    }

    protected RES postProcessParsedResponse(RES response) {
        return response;
    }

    HttpUriRequest createFullHttpRequest(REQ request) throws VonageClientException {
        RequestBuilder rqb = this.applyAuth(this.makeRequest(request));
        this.httpWrapper.getHttpConfig().getCustomHeaders().forEach((arg_0, arg_1) -> ((RequestBuilder)rqb).setHeader(arg_0, arg_1));
        return rqb.setHeader("User-Agent", this.httpWrapper.getUserAgent()).setCharset(StandardCharsets.UTF_8).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RES execute(REQ request) throws VonageApiResponseException, VonageResponseParseException {
        HttpUriRequest httpRequest = this.createFullHttpRequest(request);
        if (AbstractMethod.shouldLog()) {
            LOGGER.log(LOG_LEVEL, "Request " + httpRequest.getMethod() + " " + httpRequest.getURI());
            StringBuilder headersStr = new StringBuilder("--- REQUEST HEADERS ---");
            for (Header header : httpRequest.getAllHeaders()) {
                headersStr.append('\n').append(header.getName()).append(": ").append(header.getValue());
            }
            LOGGER.log(LOG_LEVEL, headersStr.toString());
            LOGGER.log(LOG_LEVEL, "--- REQUEST BODY ---\n" + request);
        }
        try {
            CloseableHttpResponse response = this.httpWrapper.getHttpClient().execute(httpRequest);
            try {
                RES responseBody;
                if (AbstractMethod.shouldLog()) {
                    LOGGER.log(LOG_LEVEL, "Response " + response.getStatusLine());
                    Header[] headers = response.getAllHeaders();
                    if (headers != null && headers.length > 0) {
                        StringBuilder headersStr = new StringBuilder("--- RESPONSE HEADERS ---");
                        for (Header header : headers) {
                            headersStr.append('\n').append(header.getName()).append(": ").append(header.getValue());
                        }
                        LOGGER.log(LOG_LEVEL, headersStr.toString());
                    }
                }
                if ((responseBody = this.parseResponse((HttpResponse)response)) != null && AbstractMethod.shouldLog()) {
                    LOGGER.log(LOG_LEVEL, "--- RESPONSE BODY ---\n" + responseBody);
                }
                RES RES = this.postProcessParsedResponse(responseBody);
                return RES;
            }
            catch (IOException iox) {
                LOGGER.log(Level.WARNING, "Failed to parse response", iox);
                throw new VonageResponseParseException(iox);
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException iox) {
            LOGGER.log(Level.WARNING, "Failed to execute HTTP request", iox);
            throw new VonageMethodFailedException("Something went wrong while executing the HTTP request.", iox);
        }
    }

    final RequestBuilder applyAuth(RequestBuilder request) throws VonageClientException {
        AuthMethod am = this.getAuthMethod();
        if (am instanceof HeaderAuthMethod) {
            request.setHeader("Authorization", ((HeaderAuthMethod)am).getHeaderValue());
        }
        if (am instanceof QueryParamsAuthMethod) {
            RequestQueryParams qp = am instanceof ApiKeyQueryParamsAuthMethod ? null : AbstractMethod.normalRequestParams(request);
            ((QueryParamsAuthMethod)am).getAuthParams(qp).forEach((arg_0, arg_1) -> ((RequestBuilder)request).addParameter(arg_0, arg_1));
        }
        return request;
    }

    static RequestQueryParams normalRequestParams(RequestBuilder request) {
        return request.getParameters().stream().map(nvp -> new AbstractMap.SimpleEntry<String, String>(nvp.getName(), nvp.getValue())).collect(Collectors.toCollection(RequestQueryParams::new));
    }

    protected AuthMethod getAuthMethod() throws VonageUnexpectedException {
        return this.httpWrapper.getAuthCollection().getAcceptableAuthMethod(this.getAcceptableAuthMethods());
    }

    protected abstract Set<Class<? extends AuthMethod>> getAcceptableAuthMethods();

    protected abstract RequestBuilder makeRequest(REQ var1);

    protected abstract RES parseResponse(HttpResponse var1) throws IOException;
}

