/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.Jsonable;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.auth.AuthMethod;
import com.vonage.client.common.HttpMethod;
import java.util.Collection;
import java.util.Map;

public class CustomClient {
    private final HttpWrapper httpWrapper;

    public CustomClient(HttpWrapper httpWrapper) {
        this.httpWrapper = httpWrapper;
    }

    public <T, R> R makeRequest(HttpMethod requestMethod, String url, T requestBody, R ... responseType) {
        return (R)DynamicEndpoint.builder(this.fixResponseType(responseType)).wrapper(this.httpWrapper).requestMethod(requestMethod).authMethod(AuthMethod.class, new Class[0]).pathGetter((de, req) -> url).build().execute(requestBody);
    }

    private <R> R[] fixResponseType(R ... responseType) {
        Class<?> componentType = responseType.getClass().getComponentType();
        if (String.class.equals(componentType) || byte[].class.equals(componentType) || Jsonable.class.isAssignableFrom(componentType) || Map.class.isAssignableFrom(componentType) || Collection.class.isAssignableFrom(componentType)) {
            return responseType;
        }
        return new Void[0];
    }

    public <R> R delete(String url, R ... responseType) {
        return this.makeRequest(HttpMethod.DELETE, url, null, responseType);
    }

    public <R> R get(String url, R ... responseType) {
        return this.makeRequest(HttpMethod.GET, url, null, responseType);
    }

    public <R> R post(String url, Jsonable requestBody, R ... responseType) {
        return this.makeRequest(HttpMethod.POST, url, requestBody, responseType);
    }

    public <R> R post(String url, Map<String, ?> requestBody, R ... responseType) {
        return this.post(url, new JsonableMap(requestBody), responseType);
    }

    public <R> R put(String url, Jsonable requestBody, R ... responseType) {
        return this.makeRequest(HttpMethod.PUT, url, requestBody, responseType);
    }

    public <R> R put(String url, Map<String, ?> requestBody, R ... responseType) {
        return this.put(url, new JsonableMap(requestBody), responseType);
    }

    public <R> R patch(String url, Jsonable requestBody, R ... responseType) {
        return this.makeRequest(HttpMethod.PATCH, url, requestBody, responseType);
    }

    public <R> R patch(String url, Map<String, ?> requestBody, R ... responseType) {
        return this.patch(url, new JsonableMap(requestBody), responseType);
    }

    static final class JsonableMap
    extends JsonableBaseObject {
        @JsonAnyGetter
        @JsonAnySetter
        Map<String, Object> body;

        JsonableMap(Map<String, ?> body) {
            this.body = body;
        }
    }
}

