/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.vonage.client.AbstractMethod;
import com.vonage.client.BinaryRequest;
import com.vonage.client.HttpWrapper;
import com.vonage.client.Jsonable;
import com.vonage.client.QueryParamsRequest;
import com.vonage.client.VonageApiResponseException;
import com.vonage.client.auth.AuthMethod;
import com.vonage.client.common.HttpMethod;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class DynamicEndpoint<T, R>
extends AbstractMethod<T, R> {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final Set<Class<? extends AuthMethod>> authMethods;
    protected final String contentType;
    protected final String accept;
    protected final HttpMethod requestMethod;
    protected final BiFunction<DynamicEndpoint<T, R>, ? super T, String> pathGetter;
    protected final Class<? extends VonageApiResponseException> responseExceptionType;
    protected final Class<R> responseType;
    protected T cachedRequestBody;

    protected DynamicEndpoint(Builder<T, R> builder) {
        super(((Builder)builder).wrapper);
        this.authMethods = Objects.requireNonNull(((Builder)builder).authMethods, "At least one auth method must be defined.");
        this.requestMethod = Objects.requireNonNull(((Builder)builder).requestMethod, "HTTP request method is required.");
        this.pathGetter = Objects.requireNonNull(((Builder)builder).pathGetter, "Path function is required.");
        this.responseType = ((Builder)builder).responseType;
        if (this.responseType == Object.class) {
            throw new IllegalStateException("Could not infer the response type.Please provide it explicitly, or do not use var when assigning the result.");
        }
        this.responseExceptionType = ((Builder)builder).responseExceptionType;
        this.contentType = ((Builder)builder).contentType;
        this.accept = ((Builder)builder).accept == null && (Jsonable.class.isAssignableFrom(this.responseType) || this.isJsonableArrayResponse()) ? ContentType.APPLICATION_JSON.getMimeType() : ((Builder)builder).accept;
    }

    public static <T, R> Builder<T, R> builder(R[] responseType) {
        return DynamicEndpoint.builder(responseType.getClass().getComponentType());
    }

    public static <T, R> Builder<T, R> builder(Class<R> responseType) {
        return new Builder(responseType);
    }

    static RequestBuilder createRequestBuilderFromRequestMethod(HttpMethod requestMethod) {
        switch (requestMethod) {
            default: {
                return RequestBuilder.get();
            }
            case POST: {
                return RequestBuilder.post();
            }
            case PATCH: {
                return RequestBuilder.patch();
            }
            case DELETE: {
                return RequestBuilder.delete();
            }
            case PUT: 
        }
        return RequestBuilder.put();
    }

    @Override
    protected final Set<Class<? extends AuthMethod>> getAcceptableAuthMethods() {
        return this.authMethods;
    }

    private boolean isJsonableArrayResponse() {
        return this.responseType.isArray() && Jsonable.class.isAssignableFrom(this.responseType.getComponentType());
    }

    private String getRequestHeader(T requestBody) {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (requestBody instanceof Jsonable) {
            return ContentType.APPLICATION_JSON.getMimeType();
        }
        if (requestBody instanceof BinaryRequest) {
            return ((BinaryRequest)requestBody).getContentType();
        }
        return null;
    }

    private static void applyQueryParams(Map<String, ?> params, RequestBuilder rqb) {
        params.forEach((k, v) -> {
            Consumer<Object> logic = obj -> rqb.addParameter(k, String.valueOf(obj));
            if (v instanceof Object[]) {
                for (Object nested : (Object[])v) {
                    logic.accept(nested);
                }
            } else if (v instanceof Iterable) {
                for (Object nested : (Iterable)v) {
                    logic.accept(nested);
                }
            } else {
                logic.accept(v);
            }
        });
    }

    public static URI buildUri(String base, Map<String, ?> requestParams) {
        RequestBuilder requestBuilder = RequestBuilder.get((String)base);
        DynamicEndpoint.applyQueryParams(requestParams, requestBuilder);
        return requestBuilder.build().getURI();
    }

    @Override
    protected final RequestBuilder makeRequest(T requestBody) {
        if (requestBody instanceof Jsonable && this.responseType.isAssignableFrom(requestBody.getClass())) {
            this.cachedRequestBody = requestBody;
        }
        RequestBuilder rqb = DynamicEndpoint.createRequestBuilderFromRequestMethod(this.requestMethod);
        String header = this.getRequestHeader(requestBody);
        if (header != null) {
            rqb.setHeader("Content-Type", header);
        }
        if (this.accept != null) {
            rqb.setHeader("Accept", this.accept);
        }
        if (requestBody instanceof QueryParamsRequest) {
            DynamicEndpoint.applyQueryParams(((QueryParamsRequest)requestBody).makeParams(), rqb);
        }
        if (requestBody instanceof Jsonable) {
            rqb.setEntity((HttpEntity)new StringEntity(((Jsonable)requestBody).toJson(), ContentType.APPLICATION_JSON));
        } else if (requestBody instanceof BinaryRequest) {
            BinaryRequest bin = (BinaryRequest)requestBody;
            rqb.setEntity((HttpEntity)new ByteArrayEntity(bin.toByteArray(), ContentType.getByMimeType((String)bin.getContentType())));
        } else if (requestBody instanceof byte[]) {
            rqb.setEntity((HttpEntity)new ByteArrayEntity((byte[])requestBody));
        }
        return rqb.setUri(this.pathGetter.apply(this, (DynamicEndpoint)requestBody));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final R parseResponse(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        this.logger.fine(() -> "Response status: " + statusCode);
        try {
            if (statusCode < 200) {
                this.logger.info(() -> ((StatusLine)statusLine).getReasonPhrase());
                R r = null;
                return r;
            }
            if (statusCode < 300) {
                R r = this.parseResponseSuccess(response);
                return r;
            }
            if (statusCode < 400) {
                R r = this.parseResponseRedirect(response);
                return r;
            }
            R r = this.parseResponseFailure(response);
            return r;
        }
        finally {
            this.cachedRequestBody = null;
        }
    }

    protected R parseResponseFromString(String response) {
        return null;
    }

    private R parseResponseRedirect(HttpResponse response) throws IOException {
        String location = response.getFirstHeader("Location").getValue();
        this.logger.fine(() -> "Redirect: " + location);
        if (URI.class.equals(this.responseType)) {
            return (R)URI.create(location);
        }
        if (String.class.equals(this.responseType)) {
            return (R)location;
        }
        return this.parseResponseSuccess(response);
    }

    private R parseResponseSuccess(HttpResponse response) throws IOException {
        if (Void.class.equals(this.responseType)) {
            this.logger.fine(() -> "No response body.");
            return null;
        }
        if (byte[].class.equals(this.responseType)) {
            byte[] result = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            this.logger.fine(() -> "Binary response body of length " + result.length);
            return (R)result;
        }
        String deser = EntityUtils.toString((HttpEntity)response.getEntity());
        this.logger.fine(() -> deser);
        if (this.responseType.equals(String.class)) {
            return (R)deser;
        }
        if (this.cachedRequestBody instanceof Jsonable) {
            ((Jsonable)this.cachedRequestBody).updateFromJson(deser);
            return (R)this.cachedRequestBody;
        }
        if (Jsonable.class.isAssignableFrom(this.responseType)) {
            return Jsonable.fromJson(deser, this.responseType);
        }
        if (Map.class.isAssignableFrom(this.responseType) || Collection.class.isAssignableFrom(this.responseType) || this.isJsonableArrayResponse()) {
            return (R)Jsonable.createDefaultObjectMapper().readValue(deser, this.responseType);
        }
        R customParsedResponse = this.parseResponseFromString(deser);
        if (customParsedResponse == null) {
            String errorMsg = "Unhandled return type: " + this.responseType;
            this.logger.severe(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        return customParsedResponse;
    }

    private R parseResponseFailure(HttpResponse response) throws IOException {
        String exMessage = EntityUtils.toString((HttpEntity)response.getEntity());
        if (this.responseExceptionType != null) {
            VonageApiResponseException varex = Jsonable.fromJson(exMessage, this.responseExceptionType);
            if (varex.title == null) {
                varex.title = response.getStatusLine().getReasonPhrase();
            }
            varex.statusCode = response.getStatusLine().getStatusCode();
            this.logger.log(Level.WARNING, "Failed to parse response", varex);
            throw varex;
        }
        R customParsedResponse = this.parseResponseFromString(exMessage);
        if (customParsedResponse == null) {
            this.logger.warning(exMessage);
            throw new VonageApiResponseException(exMessage);
        }
        return customParsedResponse;
    }

    public static final class Builder<T, R> {
        private final Class<R> responseType;
        private Set<Class<? extends AuthMethod>> authMethods;
        private HttpWrapper wrapper;
        private String contentType;
        private String accept;
        private HttpMethod requestMethod;
        private BiFunction<DynamicEndpoint<T, R>, ? super T, String> pathGetter;
        private Class<? extends VonageApiResponseException> responseExceptionType;

        Builder(Class<R> responseType) {
            this.responseType = Objects.requireNonNull(responseType, "Response type class cannot be null.");
        }

        public Builder<T, R> wrapper(HttpWrapper wrapper) {
            this.wrapper = wrapper;
            return this;
        }

        public Builder<T, R> requestMethod(HttpMethod requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder<T, R> pathGetter(BiFunction<DynamicEndpoint<T, R>, T, String> pathGetter) {
            this.pathGetter = pathGetter;
            return this;
        }

        public Builder<T, R> authMethod(Class<? extends AuthMethod> primary, Class<? extends AuthMethod> ... others) {
            this.authMethods = new LinkedHashSet<Class<? extends AuthMethod>>(2);
            this.authMethods.add(Objects.requireNonNull(primary, "Primary auth method cannot be null."));
            if (others != null) {
                for (Class<? extends AuthMethod> amc : others) {
                    if (amc == null) continue;
                    this.authMethods.add(amc);
                }
            }
            return this;
        }

        public Builder<T, R> responseExceptionType(Class<? extends VonageApiResponseException> responseExceptionType) {
            this.responseExceptionType = responseExceptionType;
            return this;
        }

        public Builder<T, R> urlFormEncodedContentType(boolean formEncoded) {
            return this.contentTypeHeader(formEncoded ? "application/x-www-form-urlencoded" : null);
        }

        public Builder<T, R> contentTypeHeader(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder<T, R> acceptHeader(String accept) {
            this.accept = accept;
            return this;
        }

        public DynamicEndpoint<T, R> build() {
            return new DynamicEndpoint(this);
        }
    }
}

