/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.application.capabilities.Capability;
import com.vonage.client.application.capabilities.Messages;
import com.vonage.client.application.capabilities.NetworkApis;
import com.vonage.client.application.capabilities.Rtc;
import com.vonage.client.application.capabilities.Vbc;
import com.vonage.client.application.capabilities.Verify;
import com.vonage.client.application.capabilities.Voice;
import java.util.Objects;
import java.util.UUID;

public final class Application
extends JsonableBaseObject {
    private UUID id;
    private String name;
    private Keys keys;
    private Capabilities capabilities;
    private Privacy privacy;

    private Application() {
    }

    private Application(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.keys = builder.keys;
        this.capabilities = builder.capabilities;
        this.privacy = builder.privacy;
    }

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="keys")
    public Keys getKeys() {
        return this.keys;
    }

    @JsonProperty(value="capabilities")
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="privacy")
    public Privacy getPrivacy() {
        return this.privacy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Application application) {
        return new Builder(application);
    }

    public static Builder builder(UUID id) {
        Builder builder = new Builder();
        builder.id = Objects.requireNonNull(id, "Application ID is required.");
        return builder;
    }

    public static final class Builder {
        UUID id;
        private Privacy privacy;
        private String name;
        private Keys keys;
        private Capabilities capabilities;

        Builder() {
        }

        Builder(Application application) {
            this.id = application.id;
            this.name = application.name;
            this.keys = application.keys;
            this.capabilities = application.capabilities;
        }

        public Builder improveAi(boolean improveAi) {
            if (this.privacy == null) {
                this.privacy = new Privacy();
            }
            this.privacy.improveAi = improveAi;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.keys = new Keys();
            this.keys.publicKey = publicKey;
            return this;
        }

        public Builder addCapability(Capability capability) {
            if (this.capabilities == null) {
                this.capabilities = new Capabilities();
            }
            this.capabilities.setCapability(capability);
            return this;
        }

        public Builder removeCapabilities(Capability.Type ... types) {
            for (Capability.Type type : types) {
                this.removeCapability(type);
            }
            return this;
        }

        public Builder removeCapability(Capability.Type type) {
            if (this.capabilities != null) {
                this.capabilities.setCapability(type, null);
                if (this.capabilities.voice == null && this.capabilities.rtc == null && this.capabilities.messages == null && this.capabilities.vbc == null && this.capabilities.verify == null && this.capabilities.networkApis == null) {
                    this.capabilities = null;
                }
            }
            return this;
        }

        public Application build() {
            return new Application(this);
        }
    }

    public static class Capabilities
    extends JsonableBaseObject {
        private Voice voice;
        private Messages messages;
        private Rtc rtc;
        private Vbc vbc;
        private Verify verify;
        private NetworkApis networkApis;

        @JsonProperty(value="voice")
        public Voice getVoice() {
            return this.voice;
        }

        @JsonProperty(value="messages")
        public Messages getMessages() {
            return this.messages;
        }

        @JsonProperty(value="rtc")
        public Rtc getRtc() {
            return this.rtc;
        }

        @JsonProperty(value="vbc")
        public Vbc getVbc() {
            return this.vbc;
        }

        @JsonProperty(value="verify")
        public Verify getVerify() {
            return this.verify;
        }

        @JsonProperty(value="network_apis")
        public NetworkApis getNetworkApis() {
            return this.networkApis;
        }

        private void setCapability(Capability.Type type, Capability capability) {
            switch (type) {
                case VOICE: {
                    this.voice = (Voice)capability;
                    break;
                }
                case MESSAGES: {
                    this.messages = (Messages)capability;
                    break;
                }
                case RTC: {
                    this.rtc = (Rtc)capability;
                    break;
                }
                case VBC: {
                    this.vbc = (Vbc)capability;
                    break;
                }
                case VERIFY: {
                    this.verify = (Verify)capability;
                    break;
                }
                case NETWORK: {
                    this.networkApis = (NetworkApis)capability;
                }
            }
        }

        private void setCapability(Capability capability) {
            this.setCapability(capability.getType(), capability);
        }
    }

    public static class Keys
    extends JsonableBaseObject {
        private String publicKey;
        private String privateKey;

        @JsonProperty(value="public_key")
        public String getPublicKey() {
            return this.publicKey;
        }

        @JsonProperty(value="private_key")
        public String getPrivateKey() {
            return this.privateKey;
        }
    }

    public static class Privacy
    extends JsonableBaseObject {
        private Boolean improveAi;

        @JsonProperty(value="improve_ai")
        public Boolean getImproveAi() {
            return this.improveAi;
        }
    }
}

