/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.vonage.client.auth.BearerAuthMethod;
import com.vonage.jwt.Jwt;
import java.util.Objects;

public class JWTAuthMethod
extends BearerAuthMethod {
    private static final int SORT_KEY = 10;
    private final Jwt jwt;
    private final String applicationId;
    private final String privateKeyContents;

    public JWTAuthMethod(String applicationId, byte[] privateKey) {
        this.applicationId = applicationId;
        this.privateKeyContents = new String(privateKey);
        this.jwt = Jwt.builder().applicationId(this.applicationId).privateKeyContents(this.privateKeyContents).build();
    }

    public String generateToken() {
        return this.jwt.generate();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Jwt.Builder newJwt() {
        return Jwt.builder().applicationId(this.applicationId).privateKeyContents(this.privateKeyContents);
    }

    @Override
    protected final String getBearerToken() {
        return this.generateToken();
    }

    @Override
    public int getSortKey() {
        return 10;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof JWTAuthMethod && super.equals(obj) && Objects.equals(this.applicationId, ((JWTAuthMethod)obj).applicationId) && Objects.equals(this.privateKeyContents, ((JWTAuthMethod)obj).privateKeyContents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.privateKeyContents);
    }
}

