/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.hashutils.HashType;
import com.vonage.client.auth.hashutils.HashUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestSigning {
    private static final Logger LOGGER = Logger.getLogger(RequestSigning.class.getName());
    public static final int MAX_ALLOWABLE_TIME_DELTA = 300000;
    public static final String PARAM_SIGNATURE = "sig";
    public static final String PARAM_TIMESTAMP = "timestamp";
    public static final String APPLICATION_JSON = "application/json";

    private RequestSigning() {
    }

    public static Map<String, String> getSignatureForRequestParameters(Map<String, String> params, String secretKey, HashType hashType) {
        return RequestSigning.constructSignatureForRequestParameters(params, secretKey, Instant.now().getEpochSecond(), hashType);
    }

    private static String clean(String str) {
        return str.replaceAll("[=&]", "_");
    }

    static String generateParamsString(SortedMap<String, String> sortedParams) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> param : sortedParams.entrySet()) {
            String name = param.getKey();
            String value = param.getValue();
            if (PARAM_SIGNATURE.equals(name) || value == null || value.trim().isEmpty()) continue;
            sb.append("&").append(RequestSigning.clean(name)).append("=").append(RequestSigning.clean(value));
        }
        return sb.toString();
    }

    static Map<String, String> constructSignatureForRequestParameters(Map<String, String> inputParams, String secretKey, long currentTimeSeconds, HashType hashType) {
        String hashed;
        String timestampStr = Long.toString(currentTimeSeconds);
        TreeMap<String, String> tempParams = new TreeMap<String, String>(inputParams);
        tempParams.put(PARAM_TIMESTAMP, timestampStr);
        String str = RequestSigning.generateParamsString(tempParams);
        try {
            hashed = HashUtil.calculate(str, secretKey, hashType);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "error...", ex);
            hashed = "no signature";
        }
        LOGGER.info("SECURITY-KEY-GENERATION -- String [ " + str + " ] Signature [ " + hashed + " ] ");
        LinkedHashMap<String, String> outputParams = new LinkedHashMap<String, String>(4);
        outputParams.put(PARAM_TIMESTAMP, timestampStr);
        outputParams.put(PARAM_SIGNATURE, hashed);
        return outputParams;
    }

    public static boolean verifyRequestSignature(InputStream inputStream, String contentType, Map<String, String[]> parameterMap, String secretKey) {
        return RequestSigning.verifyRequestSignature(contentType, inputStream, parameterMap, secretKey, System.currentTimeMillis());
    }

    protected static boolean verifyRequestSignature(String contentType, InputStream inputStream, Map<String, String[]> parameterMap, String secretKey, long currentTimeMillis) {
        return RequestSigning.verifyRequestSignature(contentType, inputStream, parameterMap, secretKey, currentTimeMillis, HashType.MD5);
    }

    static boolean verifyRequestSignature(String contentType, InputStream inputStream, Map<String, String[]> parameterMap, String secretKey, long currentTimeMillis, HashType hashType) {
        String hashed;
        long diff;
        String suppliedSignature;
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        if (APPLICATION_JSON.equals(contentType) && inputStream != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                Map map = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, String>>(){});
                for (Map.Entry entry : map.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    LOGGER.info(name + " = " + value);
                    sortedParams.put(name, value);
                }
            }
            catch (IOException iOException) {
                throw new VonageUnexpectedException("Unexpected issue when parsing JSON", iOException);
            }
        } else {
            for (Map.Entry entry : parameterMap.entrySet()) {
                String name = (String)entry.getKey();
                String value = ((String[])entry.getValue())[0];
                LOGGER.info(name + " = " + value);
                if (value == null || value.trim().isEmpty()) continue;
                sortedParams.put(name, value);
            }
        }
        if ((suppliedSignature = (String)sortedParams.get(PARAM_SIGNATURE)) == null) {
            return false;
        }
        String string = (String)sortedParams.get(PARAM_TIMESTAMP);
        long time = -1L;
        if (string != null) {
            try {
                time = Long.parseLong(string) * 1000L;
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Error parsing 'time' parameter [ " + string + " ]", e);
                time = 0L;
            }
        }
        if ((diff = currentTimeMillis - time) > 300000L || diff < -300000L) {
            LOGGER.log(Level.WARNING, "SECURITY-KEY-VERIFICATION -- BAD-TIMESTAMP ... Timestamp [ " + time + " ] delta [ " + diff + " ] max allowed delta [ " + -300000 + " ] ");
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry param : sortedParams.entrySet()) {
            if (((String)param.getKey()).equals(PARAM_SIGNATURE)) continue;
            String name = (String)param.getKey();
            String value = (String)param.getValue();
            sb.append("&").append(RequestSigning.clean(name)).append("=").append(RequestSigning.clean(value));
        }
        String str = sb.toString();
        try {
            hashed = HashUtil.calculate(str, secretKey, hashType);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "error...", ex);
            return false;
        }
        LOGGER.info("SECURITY-KEY-VERIFICATION -- String [ " + str + " ] Signature [ " + hashed + " ] SUPPLIED SIGNATURE [ " + suppliedSignature + " ] ");
        return MessageDigest.isEqual(hashed.toLowerCase().getBytes(StandardCharsets.UTF_8), suppliedSignature.toLowerCase().getBytes(StandardCharsets.UTF_8));
    }
}

