/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.camara.simswap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.E164;

class SimSwapRequest
extends JsonableBaseObject {
    private final String phoneNumber;
    private final Integer maxAge;

    SimSwapRequest(String phoneNumber) {
        this(phoneNumber, null);
    }

    SimSwapRequest(String phoneNumber, Integer maxAge) {
        this.phoneNumber = new E164(phoneNumber).toString();
        this.maxAge = maxAge;
        if (this.maxAge != null && (maxAge < 1 || maxAge > 2400)) {
            throw new IllegalArgumentException("maxAge must be between 1 and 2400 hours.");
        }
    }

    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="maxAge")
    public Integer getMaxAge() {
        return this.maxAge;
    }
}

